<?php

/**
 * Class that operate on table 'rentbillprop'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:06
 */
class RentbillpropMySqlExtDAO extends RentbillpropMySqlDAO {

    public function updatestatus($rentbillprop) {
        $sql = 'UPDATE rentbillprop SET   status = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rentbillprop->status);

        $sqlQuery->setNumber($rentbillprop->id);
        return $this->executeUpdate($sqlQuery);
    }

    public function updatestatusanddelay($rentbillprop) {
        $sql = 'UPDATE rentbillprop SET status = ?, delayvalue = ?, delaytype = ?, delypay = ?, delayreset = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($rentbillprop->status);
        $sqlQuery->set($rentbillprop->delayvalue);
        $sqlQuery->set($rentbillprop->delaytype);
        $sqlQuery->set($rentbillprop->delypay);
        $sqlQuery->set($rentbillprop->delayreset);

        $sqlQuery->setNumber($rentbillprop->id);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStatusandbillid($value, $value2) {
        $sql = 'SELECT * FROM rentbillprop WHERE status = ? and billid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        $sqlQuery->set($value2);
        return $this->getList($sqlQuery);
    }

    public function delays() {
        $sql = 'SELECT * FROM rentbillprop WHERE status = 0 and date(enddate) < "' . date('Y-m-d') . '"';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function avaiable($dateto) {
        $sql = 'SELECT * FROM rentbillprop WHERE status = 0 and date(enddate) <= "' . $dateto . '"';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function rentinthisday($day, $productid) {
        $sql = 'SELECT * FROM rentbillprop where status = 0 and productid = ' . $productid . '  and "' . $day . '" >= date(startdate) and "' . $day . '" <= date(enddate)';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /*     * ***** */

    public function rentoutstill($startdate, $enddate) {
        $sql = 'SELECT * FROM rentbillprop where status = 0 and type = 1 and  date(startdate) >= "' . $startdate . '"  and date(enddate) <= "' . $enddate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function rentoutstillwithsupplier($startdate, $enddate, $supplierid) {
        $sql = 'SELECT * FROM rentbillprop where status = 0 and type = 1 and  date(startdate) >= "' . $startdate . '"  and date(enddate) <= "' . $enddate . '" and supplierid = ' . $supplierid . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function rentdelilerved($startdate) {
        $sql = 'SELECT * FROM rentbillprop where status = 0 and  date(enddate) = "' . $startdate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function renteddate($startdate) {
        $sql = 'SELECT * FROM rentbillprop where  date(startdate) = "' . $startdate . '"';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>