<?php

/**
 * Class that operate on table 'checkwithdrawal'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class CheckwithdrawalMySqlExtDAO extends CheckwithdrawalMySqlDAO {

    public function queryByIdExt($id) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid ,a.accountnumber FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid

					WHERE c.checkwithdrawalid=' . $id . '
					ORDER BY c.checkwithdrawaldate DESC ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryByIdExtwithsuplier($id) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					left JOIN supplier s ON s.supplierid = c.supplierid
					WHERE c.checkwithdrawalid=' . $id . '
					ORDER BY c.checkwithdrawaldate DESC ';
        //print($sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function loadExt($id) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					WHERE c.checkwithdrawalid=' . $id . '
					ORDER BY c.checkwithdrawaldate DESC ';
        //print($sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function queryallExlimted($start, $end) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid

					ORDER BY c.checkwithdrawaldate  desc limit ' . $start . ',' . $end . '';
        //print($sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplieridlimted($start, $end, $suplierid) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where c.supplierid=' . $suplierid . '
					ORDER BY c.checkwithdrawaldate  desc limit ' . $start . ',' . $end . '';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithSupplierid($suplierid) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where c.supplierid=' . $suplierid . '
					ORDER BY c.checkwithdrawaldate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithSupplieridExt($suplierid) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where c.supplierid=' . $suplierid . '
					AND c.supplierid != -2
					ORDER BY c.checkwithdrawaldate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryBydatelimted($start, $end, $from, $to) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where c.checkwithdrawaldate >= "' . $from . '"  and c.checkwithdrawaldate <= "' . $to . '"
					ORDER BY c.checkwithdrawaldate  desc limit ' . $start . ',' . $end . '';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryBydate($from, $to) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where
					c.checkwithdrawaldate >= "' . $from . '"  and c.checkwithdrawaldate <= "' . $to . '"
					ORDER BY c.checkwithdrawaldate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query checks without cash transfer checks (when supplierid != -2)
    public function queryBydateExt($from, $to) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					 left JOIN supplier s ON s.supplierid = c.supplierid
					where
					c.checkwithdrawaldate >= "' . $from . '"  and c.checkwithdrawaldate <= "' . $to . '"
					AND c.supplierid != -2
					ORDER BY c.checkwithdrawaldate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query cash tranfer rows (when supplierid == -2)
    public function queryCashTransferBydate($from, $to) {
        $sql = 'SELECT c.*, b.bankname, a.accountname,a.bankid, s.suppliername,a.accountnumber  FROM checkwithdrawal c
					JOIN  bankaccount a ON a.accountid = c.bankaccountid
					JOIN  bank b ON b.bankid = a.bankid
					where
					c.checkwithdrawaldate >= "' . $from . '"  and c.checkwithdrawaldate <= "' . $to . '"
					AND c.supplierid = -2
					ORDER BY c.checkwithdrawaldate  desc';

        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateuser($checkwithdrawal, $checkwithdrawalnote) {
        $sql = 'UPDATE checkwithdrawal SET checkwithdrawaluser = ?,  checkwithdrawalnote = ?, userid = ?  WHERE checkwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($checkwithdrawal->checkwithdrawaluser);

        $sqlQuery->setString2($checkwithdrawal->checkwithdrawalnote);
        $sqlQuery->setNumber($checkwithdrawal->userid);

        $sqlQuery->setNumber($checkwithdrawal->checkwithdrawalid);



        return $this->executeUpdate($sqlQuery);
    }

    public function updatedel($checkwithdrawal) {
        $sql = 'UPDATE checkwithdrawal SET conditions=?,  userid = ?  WHERE checkwithdrawalid = ?';
        $sqlQuery = new SqlQuery($sql);




        $sqlQuery->setNumber($checkwithdrawal->conditions);
        $sqlQuery->setNumber($checkwithdrawal->userid);

        $sqlQuery->setNumber($checkwithdrawal->checkwithdrawalid);
        return $this->executeUpdate($sqlQuery);
    }

    /*    public function checkChkNoAndAccountNo($chekNo, $accNo) {
      $sql = '
      select checkwithdrawal.* from checkwithdrawal where checkwithdrawalamount=' . $chekNo . ' and bankaccountid=' . $accNo . '
      ';

      $sqlQuery = new SqlQuery($sql);
      return $this->getRow($sqlQuery);
      } */

    public function checkNoChkAndAccountNo($chekNo, $accNo) {
        $sql = '
                    select checkwithdrawal.* from checkwithdrawal where checkwithdrawalnumber=' . $chekNo . ' and bankaccountid=' . $accNo . '
               ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function runSelectQuery($sql) {
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>