<?php

/**
 * Class that operate on table 'checkdeposit'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class CheckdepositMySqlExtDAO extends CheckdepositMySqlDAO {

    public function queryAllWithLimit($startpoint, $perpage) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		  ORDER BY checkdepositid DESC
		  limit ' . $startpoint . ',' . $perpage . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOrder() {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		  ORDER BY checkdepositid DESC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithExt_search() {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		  ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDate($startDate, $endDate) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname,
		bank.bankname, client.clientname
		FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdepositdate >= "' . $startDate . '" and checkdepositdate <= "' . $endDate . '"
		  ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query checks without cash transfer checks (when clientid != -2)
    public function queryWithDateExt($startDate, $endDate) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname,
		bank.bankname, client.clientname
		FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdepositdate >= "' . $startDate . '" and checkdepositdate <= "' . $endDate . '"
		AND client.clientid != -2
		  ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOneDate($condition, $date) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname,
		bank.bankname, client.clientname
		FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdepositdate  ' . $condition . '"' . $date . '"
		AND client.clientid != -2
		  ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query cash transfer checks (when clientid == -2)
    public function queryCashTransferBydate($startDate, $endDate) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname,
		bank.bankname
		FROM checkdeposit
		JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdepositdate >= "' . $startDate . '" and checkdepositdate <= "' . $endDate . '"
		AND checkdeposit.clientid = -2
		ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithDateLimited($start, $end, $startDate, $endDate) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdepositdate >= "' . $startDate . '" and checkdepositdate <= "' . $endDate . '"
		  ORDER BY checkdepositid DESC  limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        //print($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithClientIdExt_search($clientid) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdeposit.clientid = ' . $clientid . '
		  ORDER BY checkdepositid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithClientIdLimited($start, $end, $clientid) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdeposit.clientid = ' . $clientid . '
		  ORDER BY checkdepositid DESC  limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithClientId($clientid) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdeposit.clientid = ' . $clientid . '
		  ORDER BY checkdepositid DESC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithClientIdExt($clientid) {
        $sql = 'SELECT checkdeposit.* , bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where checkdeposit.clientid = ' . $clientid . '
		AND client.clientid != -2
		  ORDER BY checkdepositid DESC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function loadEX($checkdepositid) {
        $sql = 'SELECT checkdeposit.*,
		bankaccount.accountnumber,bankaccount.accountbeginingbalance,
		 checkdeposit.bankaccountid, checkdeposit.clientid, bankaccount.accountname, bank.bankname, client.clientname  FROM checkdeposit JOIN client
		ON checkdeposit.clientid=client.clientid JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where  checkdeposit.checkdepositid =' . $checkdepositid . '
		';

        //print_r($sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function loadEX2($checkdepositid) {
        $sql = 'SELECT checkdeposit.*,
		bankaccount.accountnumber,bankaccount.accountbeginingbalance,
		 checkdeposit.bankaccountid, checkdeposit.clientid, bankaccount.accountname, bank.bankname  FROM checkdeposit
		JOIN bankaccount
		ON checkdeposit.bankaccountid=bankaccount.accountid JOIN bank
		ON bankaccount.bankid=bank.bankid
		where  checkdeposit.checkdepositid =' . $checkdepositid . '
		';

        //print_r($sql);
        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

    public function updateuser($checkdeposit, $note) {
        $sql = 'UPDATE checkdeposit SET  checkdeposituser = ?, checkdepositnote = ? WHERE checkdepositid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->set($checkdeposit->checkdeposituser);
        $sqlQuery->setString2($note);


        $sqlQuery->setNumber($checkdeposit->checkdepositid);
        return $this->executeUpdate($sqlQuery);
    }

    public function updatdel($checkdeposit) {
        $sql = 'UPDATE checkdeposit SET userid = ?, conditions = ?  WHERE checkdepositid = ?';
        $sqlQuery = new SqlQuery($sql);


        $sqlQuery->setNumber($checkdeposit->userid);
        $sqlQuery->setNumber($checkdeposit->conditions);

        $sqlQuery->setNumber($checkdeposit->checkdepositid);
        return $this->executeUpdate($sqlQuery);
    }

    public function checkChkNoAndAccountNo($chekNo, $accNo) {
        $sql = '
                    select checkdeposit.* from checkdeposit where checkdepositnumber=' . $chekNo . ' and bankaccountid=' . $accNo . '
               ';

        $sqlQuery = new SqlQuery($sql);
        return $this->getRow($sqlQuery);
    }

}

?>