<?php
/**
 * Class that operate on table 'typesimpotencetreatment'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2021-09-05 04:20
 */
class TypesimpotencetreatmentMySqlDAO implements TypesimpotencetreatmentDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return TypesimpotencetreatmentMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE typesimpotencetreatmentid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM typesimpotencetreatment';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM typesimpotencetreatment ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param typesimpotencetreatment primary key
 	 */
	public function delete($typesimpotencetreatmentid){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE typesimpotencetreatmentid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($typesimpotencetreatmentid);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param TypesimpotencetreatmentMySql typesimpotencetreatment
 	 */
	public function insert($typesimpotencetreatment){
		$sql = 'INSERT INTO typesimpotencetreatment (typesimpotencetreatmentname, typesimpotencetreatmentdate, userid, conditions, typesimpotencetreatmentcomment) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($typesimpotencetreatment->typesimpotencetreatmentname);
		$sqlQuery->set($typesimpotencetreatment->typesimpotencetreatmentdate);
		$sqlQuery->setNumber($typesimpotencetreatment->userid);
		$sqlQuery->setNumber($typesimpotencetreatment->conditions);
		$sqlQuery->setString2($typesimpotencetreatment->typesimpotencetreatmentcomment);

		$id = $this->executeInsert($sqlQuery);	
		$typesimpotencetreatment->typesimpotencetreatmentid = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param TypesimpotencetreatmentMySql typesimpotencetreatment
 	 */
	public function update($typesimpotencetreatment){
		$sql = 'UPDATE typesimpotencetreatment SET typesimpotencetreatmentname = ?, typesimpotencetreatmentdate = ?, userid = ?, conditions = ?, typesimpotencetreatmentcomment = ? WHERE typesimpotencetreatmentid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($typesimpotencetreatment->typesimpotencetreatmentname);
		$sqlQuery->set($typesimpotencetreatment->typesimpotencetreatmentdate);
		$sqlQuery->setNumber($typesimpotencetreatment->userid);
		$sqlQuery->setNumber($typesimpotencetreatment->conditions);
		$sqlQuery->setString2($typesimpotencetreatment->typesimpotencetreatmentcomment);

		$sqlQuery->setNumber($typesimpotencetreatment->typesimpotencetreatmentid);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM typesimpotencetreatment';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByTypesimpotencetreatmentname($value){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE typesimpotencetreatmentname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTypesimpotencetreatmentdate($value){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE typesimpotencetreatmentdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTypesimpotencetreatmentcomment($value){
		$sql = 'SELECT * FROM typesimpotencetreatment WHERE typesimpotencetreatmentcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByTypesimpotencetreatmentname($value){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE typesimpotencetreatmentname = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTypesimpotencetreatmentdate($value){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE typesimpotencetreatmentdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTypesimpotencetreatmentcomment($value){
		$sql = 'DELETE FROM typesimpotencetreatment WHERE typesimpotencetreatmentcomment = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return TypesimpotencetreatmentMySql 
	 */
	protected function readRow($row){
		$typesimpotencetreatment = new Typesimpotencetreatment();
		
		$typesimpotencetreatment->typesimpotencetreatmentid = $row['typesimpotencetreatmentid'];
		$typesimpotencetreatment->typesimpotencetreatmentname = $row['typesimpotencetreatmentname'];
		$typesimpotencetreatment->typesimpotencetreatmentdate = $row['typesimpotencetreatmentdate'];
		$typesimpotencetreatment->userid = $row['userid'];
		$typesimpotencetreatment->conditions = $row['conditions'];
		$typesimpotencetreatment->typesimpotencetreatmentcomment = $row['typesimpotencetreatmentcomment'];

		return $typesimpotencetreatment;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return TypesimpotencetreatmentMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>