<?php
/**
 * Class that operate on table 'showproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-09-08 12:38
 */
class ShowproductMySqlDAO implements ShowproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return ShowproductMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM showproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM showproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM showproduct ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param showproduct primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM showproduct WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param ShowproductMySql showproduct
 	 */
	public function insert($showproduct){
		$sql = 'INSERT INTO showproduct (productid, qunatity, price, total, clientid) VALUES (?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($showproduct->productid);
		$sqlQuery->setNumber($showproduct->qunatity);
		$sqlQuery->setNumber($showproduct->price);
		$sqlQuery->setNumber($showproduct->total);
		$sqlQuery->setNumber($showproduct->clientid);

		$id = $this->executeInsert($sqlQuery);	
		$showproduct->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param ShowproductMySql showproduct
 	 */
	public function update($showproduct){
		$sql = 'UPDATE showproduct SET productid = ?, qunatity = ?, price = ?, total = ?, clientid = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($showproduct->productid);
		$sqlQuery->setNumber($showproduct->qunatity);
		$sqlQuery->setNumber($showproduct->price);
		$sqlQuery->setNumber($showproduct->total);
		$sqlQuery->setNumber($showproduct->clientid);

		$sqlQuery->setNumber($showproduct->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM showproduct';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByProductid($value){
		$sql = 'SELECT * FROM showproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByQunatity($value){
		$sql = 'SELECT * FROM showproduct WHERE qunatity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByPrice($value){
		$sql = 'SELECT * FROM showproduct WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByTotal($value){
		$sql = 'SELECT * FROM showproduct WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByClientid($value){
		$sql = 'SELECT * FROM showproduct WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByProductid($value){
		$sql = 'DELETE FROM showproduct WHERE productid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByQunatity($value){
		$sql = 'DELETE FROM showproduct WHERE qunatity = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByPrice($value){
		$sql = 'DELETE FROM showproduct WHERE price = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByTotal($value){
		$sql = 'DELETE FROM showproduct WHERE total = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByClientid($value){
		$sql = 'DELETE FROM showproduct WHERE clientid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return ShowproductMySql 
	 */
	protected function readRow($row){
		$showproduct = new Showproduct();
		
		$showproduct->id = $row['id'];
		$showproduct->productid = $row['productid'];
		$showproduct->qunatity = $row['qunatity'];
		$showproduct->price = $row['price'];
		$showproduct->total = $row['total'];
		$showproduct->clientid = $row['clientid'];

		return $showproduct;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return ShowproductMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>