<?php

/**
 * Class that operate on table 'shippercompanies'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-25 14:24
 */
class ShippercompaniesMySqlDAO implements ShippercompaniesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ShippercompaniesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM shippercompanies WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM shippercompanies';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM shippercompanies ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param shippercompanie primary key
     */
    public function delete($companyId) {
        $sql = 'DELETE FROM shippercompanies WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($companyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ShippercompaniesMySql shippercompanie
     */
    public function insert($shippercompanie, $otherInfo) {
        $sql = 'INSERT INTO shippercompanies (companyName, otherInfo, tempdele) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($shippercompanie->companyName);
        $sqlQuery->setString2($otherInfo);
        $sqlQuery->setNumber($shippercompanie->tempdele);

        $id = $this->executeInsert($sqlQuery);
        $shippercompanie->companyId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ShippercompaniesMySql shippercompanie
     */
    public function update($shippercompanie, $otherInfo) {
        $sql = 'UPDATE shippercompanies SET companyName = ?, otherInfo = ?, tempdele = ? WHERE companyId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($shippercompanie->companyName);
        $sqlQuery->setString2($otherInfo);
        $sqlQuery->setNumber($shippercompanie->tempdele);

        $sqlQuery->setNumber($shippercompanie->companyId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM shippercompanies';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByCompanyName($value) {
        $sql = 'SELECT * FROM shippercompanies WHERE companyName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOtherInfo($value) {
        $sql = 'SELECT * FROM shippercompanies WHERE otherInfo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdele($value) {
        $sql = 'SELECT * FROM shippercompanies WHERE tempdele = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByCompanyName($value) {
        $sql = 'DELETE FROM shippercompanies WHERE companyName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOtherInfo($value) {
        $sql = 'DELETE FROM shippercompanies WHERE otherInfo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdele($value) {
        $sql = 'DELETE FROM shippercompanies WHERE tempdele = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ShippercompaniesMySql
     */
    protected function readRow($row) {
        $shippercompanie = new Shippercompanie();

        $shippercompanie->companyId = isset($row['companyId']) ? $row['companyId'] : '';
        $shippercompanie->companyName = isset($row['companyName']) ? $row['companyName'] : '';
        $shippercompanie->otherInfo = isset($row['otherInfo']) ? $row['otherInfo'] : '';
        $shippercompanie->tempdele = isset($row['tempdele']) ? $row['tempdele'] : '';

        return $shippercompanie;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ShippercompaniesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>