<?php

/**
 * Class that operate on table 'sellbilloffer'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-08-24 15:23
 */
class SellbillofferMySqlDAO implements SellbillofferDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillofferMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbilloffer ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbilloffer primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillofferMySql sellbilloffer
     */
    public function insert($sellbilloffer) {
        $sql = 'INSERT INTO sellbilloffer (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate,comment, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, tempclientName, sellQuantity,tax ,carnumber, cartype, carchase, carmotor,costcenterid,dailyentryid,obygyVisitId,onlineOrderId,delbyuserid,delivery,totalafterdelivery,billReservation,billReservationDate,webApiId,visaAccountId,cashPayed,visaPayed,isBankAccountTransfer,extraDiscountPer,extraDiscountVal,taxOfDiscountPer,taxOfDiscountVal,taxBillNumber,collectionType,collectionDate,qrerpid,qrerpids,autoSaveFlag,ereason,estatus,epdf,obgyBillType,billoperationid,datestarting,pricetype,orderSavedBillId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilloffer->sellbilldate);
        $sqlQuery->set($sellbilloffer->sellbillserial);
        $sqlQuery->setNumber($sellbilloffer->sellbillclientid);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptafter);
        $sqlQuery->set($sellbilloffer->sellbilldiscount);
        $sqlQuery->setNumber($sellbilloffer->sellbilldiscounttype);
        $sqlQuery->set($sellbilloffer->sellbilltotalbill);
        $sqlQuery->set($sellbilloffer->sellbillaftertotalbill);
        $sqlQuery->set($sellbilloffer->sellbilltotalpayed);
        $sqlQuery->set($sellbilloffer->sellbillfinalbill);
        $sqlQuery->setNumber($sellbilloffer->sellbillstoreid);
        $sqlQuery->set($sellbilloffer->sellbillsysdate);
        $sqlQuery->set($sellbilloffer->comment);
        $sqlQuery->setNumber($sellbilloffer->userid);
        $sqlQuery->setNumber($sellbilloffer->conditions);
        $sqlQuery->set($sellbilloffer->sellbillclientname);
        $sqlQuery->setNumber($sellbilloffer->sellbillsaveid);
        $sqlQuery->setNumber($sellbilloffer->sellbildirectpayment);
        $sqlQuery->setNumber($sellbilloffer->billnameid);
        $sqlQuery->setNumber($sellbilloffer->sellerid);
        $sqlQuery->set($sellbilloffer->tempclientName);
        $sqlQuery->setNumber($sellbilloffer->sellQuantity);

        $sqlQuery->set($sellbilloffer->tax);
        $sqlQuery->set($sellbilloffer->carnumber);
        $sqlQuery->set($sellbilloffer->cartype);
        $sqlQuery->set($sellbilloffer->carchase);
        $sqlQuery->set($sellbilloffer->carmotor);

        $sqlQuery->setNumber($sellbilloffer->costcenterid);
        $sqlQuery->set($sellbilloffer->dailyentryid);
        $sqlQuery->setNumber((int) $sellbilloffer->obygyVisitId);
        $sqlQuery->setNumber((int) $sellbilloffer->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbilloffer->delbyuserid);
        $sqlQuery->setNumber((int) $sellbilloffer->delivery);
        $sqlQuery->setNumber((int) $sellbilloffer->totalafterdelivery);
        $sqlQuery->setNumber((int) $sellbilloffer->billReservation);
        $sqlQuery->set($sellbilloffer->billReservationDate);
        $sqlQuery->setNumber((int) $sellbilloffer->webApiId);
        $sqlQuery->setNumber((int) $sellbilloffer->visaAccountId);
        $sqlQuery->setNumber((float) $sellbilloffer->cashPayed);
        $sqlQuery->setNumber((float) $sellbilloffer->visaPayed);
        $sqlQuery->setNumber((int) $sellbilloffer->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbilloffer->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbilloffer->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbilloffer->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbilloffer->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbilloffer->taxBillNumber);
        $sqlQuery->setNumber((int) $sellbilloffer->collectionType);
        $sqlQuery->set($sellbilloffer->collectionDate);
        $sqlQuery->set($sellbilloffer->qrerpid);
        $sqlQuery->set($sellbilloffer->qrerpids);
        $sqlQuery->setNumber((int) $sellbilloffer->autoSaveFlag);
        $sqlQuery->set($sellbilloffer->ereason);
        $sqlQuery->setNumber((int) $sellbilloffer->estatus);
        $sqlQuery->set($sellbilloffer->epdf);
        $sqlQuery->setNumber((int) $sellbilloffer->obgyBillType);
        $sqlQuery->setNumber((int) $sellbilloffer->billoperationid);
        $sqlQuery->set($sellbilloffer->datestarting);
        $sqlQuery->setNumber((int) $sellbilloffer->pricetype);
        $sqlQuery->setNumber((int) $sellbilloffer->orderSavedBillId);

        $id = $this->executeInsert($sqlQuery);
        $sellbilloffer->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillofferMySql sellbilloffer
     */
    public function update($sellbilloffer) {
        $sql = 'UPDATE sellbilloffer SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?,comment = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, tempclientName = ?, sellQuantity = ? , dailyentryid = ?,obygyVisitId = ?,onlineOrderId = ?,delbyuserid = ?,delivery = ?,totalafterdelivery = ?,billReservation=?,billReservationDate=?,visaAccountId = ?,cashPayed = ?,visaPayed = ?,isBankAccountTransfer = ?,extraDiscountPer=?,extraDiscountVal=?,taxOfDiscountPer=?,taxOfDiscountVal=?,taxBillNumber=?,collectionType = ?,collectionDate=?,qrerpid=?,qrerpids=?,autoSaveFlag=?,ereason=?,estatus=?,epdf=?,obgyBillType=?,billoperationid=?,datestarting=?,pricetype=? WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilloffer->sellbilldate);
        $sqlQuery->set($sellbilloffer->sellbillserial);
        $sqlQuery->setNumber($sellbilloffer->sellbillclientid);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbilloffer->sellbilltotaldeptafter);
        $sqlQuery->set($sellbilloffer->sellbilldiscount);
        $sqlQuery->setNumber($sellbilloffer->sellbilldiscounttype);
        $sqlQuery->set($sellbilloffer->sellbilltotalbill);
        $sqlQuery->set($sellbilloffer->sellbillaftertotalbill);
        $sqlQuery->set($sellbilloffer->sellbilltotalpayed);
        $sqlQuery->set($sellbilloffer->sellbillfinalbill);
        $sqlQuery->setNumber($sellbilloffer->sellbillstoreid);
        $sqlQuery->set($sellbilloffer->sellbillsysdate);
        $sqlQuery->set($sellbilloffer->comment);
        $sqlQuery->setNumber($sellbilloffer->userid);
        $sqlQuery->setNumber($sellbilloffer->conditions);
        $sqlQuery->set($sellbilloffer->sellbillclientname);
        $sqlQuery->setNumber($sellbilloffer->sellbillsaveid);
        $sqlQuery->setNumber($sellbilloffer->sellbildirectpayment);
        $sqlQuery->setNumber($sellbilloffer->billnameid);
        $sqlQuery->setNumber($sellbilloffer->sellerid);
        $sqlQuery->set($sellbilloffer->tempclientName);
        $sqlQuery->setNumber($sellbilloffer->sellQuantity);
        $sqlQuery->set($sellbilloffer->dailyentryid);
        $sqlQuery->setNumber((int) $sellbilloffer->obygyVisitId);
        $sqlQuery->setNumber((int) $sellbilloffer->onlineOrderId);
        $sqlQuery->setNumber((int) $sellbilloffer->delbyuserid);
        $sqlQuery->setNumber((int) $sellbilloffer->delivery);
        $sqlQuery->setNumber((int) $sellbilloffer->totalafterdelivery);
        $sqlQuery->setNumber((int) $sellbilloffer->billReservation);
        $sqlQuery->set($sellbilloffer->billReservationDate);
        $sqlQuery->setNumber((int) $sellbilloffer->visaAccountId);
        $sqlQuery->setNumber((float) $sellbilloffer->cashPayed);
        $sqlQuery->setNumber((float) $sellbilloffer->visaPayed);
        $sqlQuery->setNumber((int) $sellbilloffer->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbilloffer->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbilloffer->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbilloffer->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbilloffer->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbilloffer->taxBillNumber);
        $sqlQuery->setNumber((int) $sellbilloffer->collectionType);
        $sqlQuery->set($sellbilloffer->collectionDate);
        $sqlQuery->set($sellbilloffer->qrerpid);
        $sqlQuery->set($sellbilloffer->qrerpids);
        $sqlQuery->setNumber((int) $sellbilloffer->autoSaveFlag);
        $sqlQuery->set($sellbilloffer->ereason);
        $sqlQuery->setNumber((int) $sellbilloffer->estatus);
        $sqlQuery->set($sellbilloffer->epdf);
        $sqlQuery->set((int) $sellbilloffer->obgyBillType);
        $sqlQuery->set((int) $sellbilloffer->billoperationid);
        $sqlQuery->set($sellbilloffer->datestarting);
        $sqlQuery->setNumber((int) $sellbilloffer->datestarting);

        $sqlQuery->setNumber($sellbilloffer->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbilloffer';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempclientName($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellQuantity($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeletedsellid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByControlname($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTax($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarnumber($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCartype($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE cartype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarchase($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carchase = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCarmotor($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE carmotor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCostcenterid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLocaldonw($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByObygyVisitId($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE obygyVisitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOnlineOrderId($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelbyuserid($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewType($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewUser($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLastReviewDateTime($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE lastReviewDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDelivery($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTotalafterdelivery($value) {
        $sql = 'SELECT * FROM sellbilloffer WHERE totalafterdelivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempclientName($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE tempclientName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellQuantity($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE sellQuantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeletedsellid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE deletedsellid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByControlname($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE controlname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTax($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE tax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarnumber($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carnumber = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCartype($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE cartype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarchase($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carchase = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCarmotor($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE carmotor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCostcenterid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE costcenterid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLocaldonw($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE localdonw = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByObygyVisitId($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE obygyVisitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOnlineOrderId($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE onlineOrderId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelbyuserid($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE delbyuserid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewType($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewType = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewUser($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewUser = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLastReviewDateTime($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE lastReviewDateTime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDelivery($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE delivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTotalafterdelivery($value) {
        $sql = 'DELETE FROM sellbilloffer WHERE totalafterdelivery = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillofferMySql
     */
    protected function readRow($row) {
        $sellbilloffer = new Sellbilloffer();

        $sellbilloffer->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellbilloffer->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $sellbilloffer->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $sellbilloffer->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $sellbilloffer->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $sellbilloffer->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $sellbilloffer->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellbilloffer->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellbilloffer->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $sellbilloffer->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $sellbilloffer->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $sellbilloffer->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $sellbilloffer->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $sellbilloffer->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $sellbilloffer->comment = isset($row['comment']) ? $row['comment'] : '';
        $sellbilloffer->userid = isset($row['userid']) ? $row['userid'] : '';
        $sellbilloffer->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $sellbilloffer->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $sellbilloffer->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $sellbilloffer->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $sellbilloffer->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $sellbilloffer->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $sellbilloffer->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $sellbilloffer->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';

        $sellbilloffer->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $sellbilloffer->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $sellbilloffer->tax = isset($row['tax']) ? $row['tax'] : '';
        $sellbilloffer->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $sellbilloffer->obygyVisitId = isset($row['obygyVisitId']) ? $row['obygyVisitId'] : '';
        $sellbilloffer->onlineOrderId = isset($row['onlineOrderId']) ? $row['onlineOrderId'] : '';
        $sellbilloffer->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $sellbilloffer->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';



        $sellbilloffer->carnumber = isset($row['carnumber']) ? $row['carnumber'] : '';
        $sellbilloffer->cartype = isset($row['cartype']) ? $row['cartype'] : '';
        $sellbilloffer->carchase = isset($row['carchase']) ? $row['carchase'] : '';
        $sellbilloffer->carmotor = isset($row['carmotor']) ? $row['carmotor'] : '';
        //required
        $sellbilloffer->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $sellbilloffer->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sellbilloffer->savename = isset($row['savename']) ? $row['savename'] : '';
        $sellbilloffer->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $sellbilloffer->useremployeename = isset($row['useremployeename']) ? $row['useremployeename'] : '';
        $sellbilloffer->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $sellbilloffer->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $sellbilloffer->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellbilloffer->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellbilloffer->theDate = isset($row['theDate']) ? $row['theDate'] : '';
        $sellbilloffer->allGenTotal = isset($row['allGenTotal']) ? $row['allGenTotal'] : '';
        $sellbilloffer->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';
        $sellbilloffer->newSellbillidAfterEdit = isset($row['newSellbillidAfterEdit']) ? $row['newSellbillidAfterEdit'] : '';
        $sellbilloffer->visaAccountId = isset($row['visaAccountId']) ? $row['visaAccountId'] : '';
        $sellbilloffer->cashPayed = isset($row['cashPayed']) ? $row['cashPayed'] : '';
        $sellbilloffer->visaPayed = isset($row['visaPayed']) ? $row['visaPayed'] : '';
        $sellbilloffer->isBankAccountTransfer = isset($row['isBankAccountTransfer']) ? $row['isBankAccountTransfer'] : '';
        $sellbilloffer->extraDiscountPer = isset($row['extraDiscountPer']) ? $row['extraDiscountPer'] : '';
        $sellbilloffer->extraDiscountVal = isset($row['extraDiscountVal']) ? $row['extraDiscountVal'] : '';
        $sellbilloffer->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $sellbilloffer->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $sellbilloffer->taxBillNumber = isset($row['taxBillNumber']) ? $row['taxBillNumber'] : '';
        $sellbilloffer->collectionType = isset($row['collectionType']) ? $row['collectionType'] : '';
        $sellbilloffer->collectionDate = isset($row['collectionDate']) ? $row['collectionDate'] : '';

        //m7md
        $sellbilloffer->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $sellbilloffer->sumTotalbill = isset($row['sumTotalbill']) ? $row['sumTotalbill'] : '';
        $sellbilloffer->sumDiscount = isset($row['sumDiscount']) ? $row['sumDiscount'] : '';
        $sellbilloffer->productid = isset($row['productid']) ? $row['productid'] : '';
        $sellbilloffer->productName = isset($row['productName']) ? $row['productName'] : '';
        $sellbilloffer->sellbilltotalAllPayed = isset($row['sellbilltotalAllPayed']) ? $row['sellbilltotalAllPayed'] : '';
        $sellbilloffer->username = isset($row['username']) ? $row['username'] : '';
        $sellbilloffer->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellbilloffer->clientdebt = isset($row['clientdebt']) ? $row['clientdebt'] : '';

        $sellbilloffer->countsellbill = isset($row['countsellbill']) ? $row['countsellbill'] : '';
        $sellbilloffer->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';
        $sellbilloffer->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';
        $sellbilloffer->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellbilloffer->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $sellbilloffer->colorid = isset($row['colorid']) ? $row['colorid'] : '';

        $sellbilloffer->reviewType = isset($row['reviewType']) ? $row['reviewType'] : '';
        $sellbilloffer->lastReviewType = isset($row['lastReviewType']) ? $row['lastReviewType'] : '';
        $sellbilloffer->lastReviewUser = isset($row['lastReviewUser']) ? $row['lastReviewUser'] : '';
        $sellbilloffer->lastReviewDateTime = isset($row['lastReviewDateTime']) ? $row['lastReviewDateTime'] : '';
        $sellbilloffer->orderSavedBillId = isset($row['orderSavedBillId']) ? $row['orderSavedBillId'] : '';

        $sellbilloffer->delivery = isset($row['delivery']) ? $row['delivery'] : '';
        $sellbilloffer->totalafterdelivery = isset($row['totalafterdelivery']) ? $row['totalafterdelivery'] : '';
        $sellbilloffer->billReservation = isset($row['billReservation']) ? $row['billReservation'] : '';
        $sellbilloffer->billReservationDate = isset($row['billReservationDate']) ? $row['billReservationDate'] : '';
        $sellbilloffer->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $sellbilloffer->shippingDate = isset($row['shippingDate']) ? $row['shippingDate'] : '';
        $sellbilloffer->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $sellbilloffer->qrerpid = isset($row['qrerpid']) ? $row['qrerpid'] : '';
        $sellbilloffer->qrerpids = isset($row['qrerpids']) ? $row['qrerpids'] : '';
        $sellbilloffer->taxnumber = isset($row['taxnumber']) ? $row['taxnumber'] : '';
        $sellbilloffer->autoSaveFlag = isset($row['autoSaveFlag']) ? $row['autoSaveFlag'] : '';
        $sellbilloffer->ereason = isset($row['ereason']) ? $row['ereason'] : '';
        $sellbilloffer->estatus = isset($row['estatus']) ? $row['estatus'] : '';
        $sellbilloffer->epdf = isset($row['epdf']) ? $row['epdf'] : '';
        $sellbilloffer->obgyBillType = isset($row['obgyBillType']) ? $row['obgyBillType'] : '';
        $sellbilloffer->billoperationid = isset($row['billoperationid']) ? $row['billoperationid'] : '';
        $sellbilloffer->datestarting = isset($row['datestarting']) ? $row['datestarting'] : '';

        return $sellbilloffer;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillofferMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>