<?php

/**
 * Class that operate on table 'sellbilldetailorder'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-05 16:27
 */
class SellbilldetailorderMySqlDAO implements SellbilldetailorderDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbilldetailorderMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbilldetailorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbilldetailorder ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbilldetailorder primary key
     */
    public function delete($sellbilldetailid) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbilldetailorderMySql sellbilldetailorder
     */
    public function insert($sellbilldetailorder) {
        $sql = 'INSERT INTO sellbilldetailorder (buyprice, parcode, sellbillid, sellbilldetailcatid, sellbilldetailproductid, sellbilldetailquantity, sellbilldetailprice, sellbilldetailtotalprice, discountvalue, note, pricetype, sellbilldetaildate, productunitid, buydiscount, buydiscounttype, storeid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetailorder->buyprice);
        $sqlQuery->set($sellbilldetailorder->parcode);
        $sqlQuery->setNumber($sellbilldetailorder->sellbillid);
        $sqlQuery->setNumber($sellbilldetailorder->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetailorder->sellbilldetailproductid);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailprice);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetailorder->discountvalue);
        $sqlQuery->set($sellbilldetailorder->note);
        $sqlQuery->setNumber($sellbilldetailorder->pricetype);
        $sqlQuery->set($sellbilldetailorder->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetailorder->productunitid);
        $sqlQuery->set($sellbilldetailorder->buydiscount);
        $sqlQuery->setNumber($sellbilldetailorder->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetailorder->storeid);

        $id = $this->executeInsert($sqlQuery);
        $sellbilldetailorder->sellbilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbilldetailorderMySql sellbilldetailorder
     */
    public function update($sellbilldetailorder) {
        $sql = 'UPDATE sellbilldetailorder SET buyprice = ?, parcode = ?, sellbillid = ?, sellbilldetailcatid = ?, sellbilldetailproductid = ?, sellbilldetailquantity = ?, sellbilldetailprice = ?, sellbilldetailtotalprice = ?, discountvalue = ?, note = ?, pricetype = ?, sellbilldetaildate = ?, productunitid = ?, buydiscount = ?, buydiscounttype = ?, storeid = ? WHERE sellbilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sellbilldetailorder->buyprice);
        $sqlQuery->set($sellbilldetailorder->parcode);
        $sqlQuery->setNumber($sellbilldetailorder->sellbillid);
        $sqlQuery->setNumber($sellbilldetailorder->sellbilldetailcatid);
        $sqlQuery->setNumber($sellbilldetailorder->sellbilldetailproductid);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailquantity);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailprice);
        $sqlQuery->set($sellbilldetailorder->sellbilldetailtotalprice);
        $sqlQuery->set($sellbilldetailorder->discountvalue);
        $sqlQuery->set($sellbilldetailorder->note);
        $sqlQuery->setNumber($sellbilldetailorder->pricetype);
        $sqlQuery->set($sellbilldetailorder->sellbilldetaildate);
        $sqlQuery->setNumber($sellbilldetailorder->productunitid);
        $sqlQuery->set($sellbilldetailorder->buydiscount);
        $sqlQuery->setNumber($sellbilldetailorder->buydiscounttype);
        $sqlQuery->setNumber($sellbilldetailorder->storeid);

        $sqlQuery->setNumber($sellbilldetailorder->sellbilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbilldetailorder';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByBuyprice($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillid($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailcatid($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailproductid($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailquantity($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailprice($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetailtotalprice($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPricetype($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldetaildate($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductunitid($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscount($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBuydiscounttype($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM sellbilldetailorder WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByBuyprice($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE buyprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillid($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailcatid($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailproductid($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailquantity($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailprice($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetailtotalprice($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPricetype($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE pricetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldetaildate($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE sellbilldetaildate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductunitid($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE productunitid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscount($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE buydiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBuydiscounttype($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE buydiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM sellbilldetailorder WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbilldetailorderMySql
     */
    protected function readRow($row) {
        $sellbilldetailorder = new Sellbilldetailorder();

        $sellbilldetailorder->buyprice = isset($row['buyprice']) ? $row['buyprice'] : '';
        $sellbilldetailorder->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $sellbilldetailorder->sellbilldetailid = isset($row['sellbilldetailid']) ? $row['sellbilldetailid'] : '';
        $sellbilldetailorder->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellbilldetailorder->sellbilldetailcatid = isset($row['sellbilldetailcatid']) ? $row['sellbilldetailcatid'] : '';
        $sellbilldetailorder->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellbilldetailorder->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellbilldetailorder->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellbilldetailorder->sellbilldetailtotalprice = isset($row['sellbilldetailtotalprice']) ? $row['sellbilldetailtotalprice'] : '';
        $sellbilldetailorder->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $sellbilldetailorder->note = isset($row['note']) ? $row['note'] : '';
        $sellbilldetailorder->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellbilldetailorder->sellbilldetaildate = isset($row['sellbilldetaildate']) ? $row['sellbilldetaildate'] : '';
        $sellbilldetailorder->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $sellbilldetailorder->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $sellbilldetailorder->buydiscounttype = isset($row['buydiscounttype']) ? $row['buydiscounttype'] : '';
        $sellbilldetailorder->storeid = isset($row['storeid']) ? $row['storeid'] : '';

        return $sellbilldetailorder;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbilldetailorderMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>