<?php

/**
 * Class that operate on table 'sellbillandrutern'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-29 13:54
 */
class SellbillandruternMySqlDAO implements SellbillandruternDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SellbillandruternMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sellbillandrutern';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sellbillandrutern ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sellbillandrutern primary key
     */
    public function delete($sellbillid) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SellbillandruternMySql sellbillandrutern
     */
    /*
      public function insert($sellbillandrutern){
      $sql = 'INSERT INTO sellbillandrutern (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, sellbillprice, returnsellbillprice, tempclientName,sellQuantity, returnsellQuantity,tax ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
      $sqlQuery = new SqlQuery($sql);



      $sqlQuery->set($sellbillandrutern->sellbilldate);
      $sqlQuery->set($sellbillandrutern->sellbillserial);
      $sqlQuery->setNumber($sellbillandrutern->sellbillclientid);
      $sqlQuery->set($sellbillandrutern->sellbilltotaldeptbefor);
      $sqlQuery->set($sellbillandrutern->sellbilltotaldeptafter);
      $sqlQuery->set($sellbillandrutern->sellbilldiscount);
      $sqlQuery->setNumber($sellbillandrutern->sellbilldiscounttype);
      $sqlQuery->set($sellbillandrutern->sellbilltotalbill);
      $sqlQuery->set($sellbillandrutern->sellbillaftertotalbill);
      $sqlQuery->set($sellbillandrutern->sellbilltotalpayed);
      $sqlQuery->set($sellbillandrutern->sellbillfinalbill);
      $sqlQuery->setNumber($sellbillandrutern->sellbillstoreid);
      $sqlQuery->set($sellbillandrutern->sellbillsysdate);
      $sqlQuery->setNumber($sellbillandrutern->userid);
      $sqlQuery->setNumber($sellbillandrutern->conditions);
      $sqlQuery->set($sellbillandrutern->sellbillclientname);
      $sqlQuery->setNumber($sellbillandrutern->sellbillsaveid);
      $sqlQuery->setNumber($sellbillandrutern->sellbildirectpayment);
      $sqlQuery->setNumber($sellbillandrutern->billnameid);
      $sqlQuery->setNumber($sellbillandrutern->sellerid);
      $sqlQuery->set($sellbillandrutern->sellbillprice);
      $sqlQuery->set($sellbillandrutern->returnsellbillprice);
      $sqlQuery->set($sellbillandrutern->tempclientName);
      $sqlQuery->setNumber($sellbillandrutern->sellQuantity);
      $sqlQuery->setNumber($sellbillandrutern->returnsellQuantity);
      $sqlQuery->set($sellbillandrutern->tax);



      $id = $this->executeInsert($sqlQuery);
      $sellbillandrutern->sellbillid = $id;
      return $id;
      }
     */
    public function insert($sellbillandrutern) {
        $sql = 'INSERT INTO sellbillandrutern (sellbilldate, sellbillserial, sellbillclientid, sellbilltotaldeptbefor, sellbilltotaldeptafter, sellbilldiscount, sellbilldiscounttype, sellbilltotalbill, sellbillaftertotalbill, sellbilltotalpayed, sellbillfinalbill, sellbillstoreid, sellbillsysdate,comment, userid, conditions, sellbillclientname, sellbillsaveid, sellbildirectpayment, billnameid, sellerid, sellbillprice, returnsellbillprice, tempclientName,sellQuantity, returnsellQuantity, tax, carnumber, cartype, carchase, carmotor,costcenterid,dailyentryid,delbyuserid,billReservation,billReservationDate,visaAccountId,cashPayed,visaPayed,isBankAccountTransfer,extraDiscountPer,extraDiscountVal,taxOfDiscountPer,taxOfDiscountVal,autoSaveFlag,obgyBillType,billoperationid,pricetype,currencyId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);



        $sqlQuery->set($sellbillandrutern->sellbilldate);
        $sqlQuery->set($sellbillandrutern->sellbillserial);
        $sqlQuery->setNumber($sellbillandrutern->sellbillclientid);
        $sqlQuery->set($sellbillandrutern->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbillandrutern->sellbilltotaldeptafter);
        $sqlQuery->set($sellbillandrutern->sellbilldiscount);
        $sqlQuery->setNumber($sellbillandrutern->sellbilldiscounttype);
        $sqlQuery->set($sellbillandrutern->sellbilltotalbill);
        $sqlQuery->set($sellbillandrutern->sellbillaftertotalbill);
        $sqlQuery->set($sellbillandrutern->sellbilltotalpayed);
        $sqlQuery->set($sellbillandrutern->sellbillfinalbill);
        $sqlQuery->setNumber($sellbillandrutern->sellbillstoreid);
        $sqlQuery->set($sellbillandrutern->sellbillsysdate);
        $sqlQuery->set($sellbillandrutern->comment);
        $sqlQuery->setNumber($sellbillandrutern->userid);
        $sqlQuery->setNumber($sellbillandrutern->conditions);
        $sqlQuery->set($sellbillandrutern->sellbillclientname);
        $sqlQuery->setNumber($sellbillandrutern->sellbillsaveid);
        $sqlQuery->setNumber($sellbillandrutern->sellbildirectpayment);
        $sqlQuery->setNumber($sellbillandrutern->billnameid);

        $sqlQuery->setNumber($sellbillandrutern->sellerid);
        $sqlQuery->set($sellbillandrutern->sellbillprice);
        $sqlQuery->set($sellbillandrutern->returnsellbillprice);
        $sqlQuery->set($sellbillandrutern->tempclientName);
        $sqlQuery->setNumber($sellbillandrutern->sellQuantity);
        $sqlQuery->setNumber($sellbillandrutern->returnsellQuantity);
        $sqlQuery->set($sellbillandrutern->tax);
        $sqlQuery->set($sellbillandrutern->carnumber);
        $sqlQuery->set($sellbillandrutern->cartype);
        $sqlQuery->set($sellbillandrutern->carchase);
        $sqlQuery->set($sellbillandrutern->carmotor);

        $sqlQuery->setNumber($sellbillandrutern->costcenterid);
        $sqlQuery->set($sellbillandrutern->dailyentryid);
        $sqlQuery->setNumber((int) $sellbillandrutern->delbyuserid);
        $sqlQuery->setNumber((int) $sellbillandrutern->billReservation);
        $sqlQuery->set($sellbillandrutern->billReservationDate);
        $sqlQuery->setNumber((int) $sellbillandrutern->visaAccountId);
        $sqlQuery->setNumber((float) $sellbillandrutern->cashPayed);
        $sqlQuery->setNumber((float) $sellbillandrutern->visaPayed);
        $sqlQuery->setNumber((int) $sellbillandrutern->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbillandrutern->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbillandrutern->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbillandrutern->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbillandrutern->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbillandrutern->autoSaveFlag);
        $sqlQuery->setNumber((int) $sellbillandrutern->obgyBillType);
        $sqlQuery->setNumber((int) $sellbillandrutern->billoperationid);
        $sqlQuery->setNumber((int) $sellbillandrutern->pricetype);
        $sqlQuery->setNumber((int) $sellbillandrutern->currencyId);



        $id = $this->executeInsert($sqlQuery);
        $sellbillandrutern->sellbillid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SellbillandruternMySql sellbillandrutern
     */
    public function update($sellbillandrutern) {
        $sql = 'UPDATE sellbillandrutern SET sellbilldate = ?, sellbillserial = ?, sellbillclientid = ?, sellbilltotaldeptbefor = ?, sellbilltotaldeptafter = ?, sellbilldiscount = ?, sellbilldiscounttype = ?, sellbilltotalbill = ?, sellbillaftertotalbill = ?, sellbilltotalpayed = ?, sellbillfinalbill = ?, sellbillstoreid = ?, sellbillsysdate = ?,comment = ?, userid = ?, conditions = ?, sellbillclientname = ?, sellbillsaveid = ?, sellbildirectpayment = ?, billnameid = ?, sellerid = ?, sellbillprice = ?, returnsellbillprice = ?, tempclientName = ?, sellQuantity = ?, returnsellQuantity = ?, dailyentryid = ?,delbyuserid = ?,billReservation=?,billReservationDate=?,visaAccountId = ?,cashPayed = ?,visaPayed = ?,isBankAccountTransfer = ?,extraDiscountPer=?,extraDiscountVal=?,taxOfDiscountPer=?,taxOfDiscountVal=?,autoSaveFlag=?,obgyBillType=?,billoperationid=?,pricetype=?,currencyId=?  WHERE sellbillid = ?';
        $sqlQuery = new SqlQuery($sql);



        $sqlQuery->set($sellbillandrutern->sellbilldate);
        $sqlQuery->set($sellbillandrutern->sellbillserial);
        $sqlQuery->setNumber($sellbillandrutern->sellbillclientid);
        $sqlQuery->set($sellbillandrutern->sellbilltotaldeptbefor);
        $sqlQuery->set($sellbillandrutern->sellbilltotaldeptafter);
        $sqlQuery->set($sellbillandrutern->sellbilldiscount);
        $sqlQuery->setNumber($sellbillandrutern->sellbilldiscounttype);
        $sqlQuery->set($sellbillandrutern->sellbilltotalbill);
        $sqlQuery->set($sellbillandrutern->sellbillaftertotalbill);
        $sqlQuery->set($sellbillandrutern->sellbilltotalpayed);
        $sqlQuery->set($sellbillandrutern->sellbillfinalbill);
        $sqlQuery->setNumber($sellbillandrutern->sellbillstoreid);
        $sqlQuery->set($sellbillandrutern->sellbillsysdate);
        $sqlQuery->set($sellbillandrutern->comment);
        $sqlQuery->setNumber($sellbillandrutern->userid);
        $sqlQuery->setNumber($sellbillandrutern->conditions);
        $sqlQuery->set($sellbillandrutern->sellbillclientname);
        $sqlQuery->setNumber($sellbillandrutern->sellbillsaveid);
        $sqlQuery->setNumber($sellbillandrutern->sellbildirectpayment);
        $sqlQuery->setNumber($sellbillandrutern->billnameid);
        $sqlQuery->setNumber($sellbillandrutern->sellerid);
        $sqlQuery->set($sellbillandrutern->sellbillprice);
        $sqlQuery->set($sellbillandrutern->returnsellbillprice);
        $sqlQuery->set($sellbillandrutern->tempclientName);
        $sqlQuery->setNumber($sellbillandrutern->sellQuantity);
        $sqlQuery->setNumber($sellbillandrutern->returnsellQuantity);
        $sqlQuery->set($sellbillandrutern->dailyentryid);
        $sqlQuery->setNumber((int) $sellbillandrutern->delbyuserid);
        $sqlQuery->setNumber((int) $sellbillandrutern->billReservation);
        $sqlQuery->set($sellbillandrutern->billReservationDate);
        $sqlQuery->setNumber((int) $sellbillandrutern->visaAccountId);
        $sqlQuery->setNumber((float) $sellbillandrutern->cashPayed);
        $sqlQuery->setNumber((float) $sellbillandrutern->visaPayed);
        $sqlQuery->setNumber((int) $sellbillandrutern->isBankAccountTransfer);
        $sqlQuery->setNumber((float) $sellbillandrutern->extraDiscountPer);
        $sqlQuery->setNumber((float) $sellbillandrutern->extraDiscountVal);
        $sqlQuery->setNumber((float) $sellbillandrutern->taxOfDiscountPer);
        $sqlQuery->setNumber((float) $sellbillandrutern->taxOfDiscountVal);
        $sqlQuery->setNumber((int) $sellbillandrutern->autoSaveFlag);
        $sqlQuery->setNumber((int) $sellbillandrutern->obgyBillType);
        $sqlQuery->setNumber((int) $sellbillandrutern->billoperationid);
        $sqlQuery->setNumber((int) $sellbillandrutern->pricetype);
        $sqlQuery->setNumber((int) $sellbillandrutern->currencyId);


        $sqlQuery->setNumber($sellbillandrutern->sellbillid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sellbillandrutern';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryBySellbilldate($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillserial($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptbefor($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotaldeptafter($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscount($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilldiscounttype($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalbill($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillaftertotalbill($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbilltotalpayed($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillfinalbill($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillstoreid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsysdate($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillclientname($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbillsaveid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellbildirectpayment($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillnameid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellerid($value) {
        $sql = 'SELECT * FROM sellbillandrutern WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteBySellbilldate($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilldate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillserial($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillserial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillclientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptbefor($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilltotaldeptbefor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotaldeptafter($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilltotaldeptafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscount($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilldiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilldiscounttype($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilldiscounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalbill($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilltotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillaftertotalbill($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillaftertotalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbilltotalpayed($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbilltotalpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillfinalbill($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillfinalbill = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillstoreid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillstoreid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsysdate($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillsysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillclientname($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillclientname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbillsaveid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbillsaveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellbildirectpayment($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellbildirectpayment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillnameid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE billnameid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellerid($value) {
        $sql = 'DELETE FROM sellbillandrutern WHERE sellerid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SellbillandruternMySql
     */
    protected function readRow($row) {
        $sellbillandrutern = new Sellbillandrutern();

        $sellbillandrutern->sellbillid = isset($row['sellbillid']) ? $row['sellbillid'] : '';
        $sellbillandrutern->sellbilldate = isset($row['sellbilldate']) ? $row['sellbilldate'] : '';
        $sellbillandrutern->sellbillserial = isset($row['sellbillserial']) ? $row['sellbillserial'] : '';
        $sellbillandrutern->sellbillclientid = isset($row['sellbillclientid']) ? $row['sellbillclientid'] : '';
        $sellbillandrutern->sellbilltotaldeptbefor = isset($row['sellbilltotaldeptbefor']) ? $row['sellbilltotaldeptbefor'] : '';
        $sellbillandrutern->sellbilltotaldeptafter = isset($row['sellbilltotaldeptafter']) ? $row['sellbilltotaldeptafter'] : '';
        $sellbillandrutern->sellbilldiscount = isset($row['sellbilldiscount']) ? $row['sellbilldiscount'] : '';
        $sellbillandrutern->sellbilldiscounttype = isset($row['sellbilldiscounttype']) ? $row['sellbilldiscounttype'] : '';
        $sellbillandrutern->sellbilltotalbill = isset($row['sellbilltotalbill']) ? $row['sellbilltotalbill'] : '';
        $sellbillandrutern->sellbillaftertotalbill = isset($row['sellbillaftertotalbill']) ? $row['sellbillaftertotalbill'] : '';
        $sellbillandrutern->sellbilltotalpayed = isset($row['sellbilltotalpayed']) ? $row['sellbilltotalpayed'] : '';
        $sellbillandrutern->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $sellbillandrutern->sellbillstoreid = isset($row['sellbillstoreid']) ? $row['sellbillstoreid'] : '';
        $sellbillandrutern->sellbillsysdate = isset($row['sellbillsysdate']) ? $row['sellbillsysdate'] : '';
        $sellbillandrutern->comment = isset($row['comment']) ? $row['comment'] : '';
        $sellbillandrutern->userid = isset($row['userid']) ? $row['userid'] : '';
        $sellbillandrutern->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $sellbillandrutern->sellbillclientname = isset($row['sellbillclientname']) ? $row['sellbillclientname'] : '';
        $sellbillandrutern->sellbillsaveid = isset($row['sellbillsaveid']) ? $row['sellbillsaveid'] : '';
        $sellbillandrutern->sellbildirectpayment = isset($row['sellbildirectpayment']) ? $row['sellbildirectpayment'] : '';
        $sellbillandrutern->billnameid = isset($row['billnameid']) ? $row['billnameid'] : '';
        $sellbillandrutern->sellerid = isset($row['sellerid']) ? $row['sellerid'] : '';
        $sellbillandrutern->sellbillprice = isset($row['sellbillprice']) ? $row['sellbillprice'] : '';
        $sellbillandrutern->returnsellbillprice = isset($row['returnsellbillprice']) ? $row['returnsellbillprice'] : '';
        $sellbillandrutern->tempclientName = isset($row['tempclientName']) ? $row['tempclientName'] : '';
        $sellbillandrutern->sellQuantity = isset($row['sellQuantity']) ? $row['sellQuantity'] : '';
        $sellbillandrutern->returnsellQuantity = isset($row['returnsellQuantity']) ? $row['returnsellQuantity'] : '';
        $sellbillandrutern->deletedsellid = isset($row['deletedsellid']) ? $row['deletedsellid'] : '';
        $sellbillandrutern->controlname = isset($row['controlname']) ? $row['controlname'] : '';
        $sellbillandrutern->tax = isset($row['tax']) ? $row['tax'] : '';
        $sellbillandrutern->carnumber = isset($row['carnumber']) ? $row['carnumber'] : '';
        $sellbillandrutern->cartype = isset($row['cartype']) ? $row['cartype'] : '';
        $sellbillandrutern->carchase = isset($row['carchase']) ? $row['carchase'] : '';
        $sellbillandrutern->carmotor = isset($row['carmotor']) ? $row['carmotor'] : '';

        //required
        $sellbillandrutern->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $sellbillandrutern->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sellbillandrutern->savename = isset($row['savename']) ? $row['savename'] : '';
        $sellbillandrutern->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $sellbillandrutern->useremployeename = isset($row['useremployeename']) ? $row['useremployeename'] : '';
        $sellbillandrutern->costcenterid = isset($row['costcenterid']) ? $row['costcenterid'] : '';
        $sellbillandrutern->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $sellbillandrutern->sellbilldetailquantity = isset($row['sellbilldetailquantity']) ? $row['sellbilldetailquantity'] : '';
        $sellbillandrutern->sellbilldetailprice = isset($row['sellbilldetailprice']) ? $row['sellbilldetailprice'] : '';
        $sellbillandrutern->selltype = isset($row['selltype']) ? $row['selltype'] : '';
        $sellbillandrutern->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $sellbillandrutern->allGenTotalSellAndReturn = isset($row['allGenTotalSellAndReturn']) ? $row['allGenTotalSellAndReturn'] : '';
        $sellbillandrutern->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';
        $sellbillandrutern->newSellbillidAfterEdit = isset($row['newSellbillidAfterEdit']) ? $row['newSellbillidAfterEdit'] : '';

        // m7md
        $sellbillandrutern->sumQuantity = isset($row['sumQuantity']) ? $row['sumQuantity'] : '';
        $sellbillandrutern->sumTotalbill = isset($row['sumTotalbill']) ? $row['sumTotalbill'] : '';
        $sellbillandrutern->sumDiscount = isset($row['sumDiscount']) ? $row['sumDiscount'] : '';
        $sellbillandrutern->sumQuantityReturend = isset($row['sumQuantityReturend']) ? $row['sumQuantityReturend'] : '';
        $sellbillandrutern->sumTotalbillReturend = isset($row['sumTotalbillReturend']) ? $row['sumTotalbillReturend'] : '';
        $sellbillandrutern->productid = isset($row['productid']) ? $row['productid'] : '';
        $sellbillandrutern->productName = isset($row['productName']) ? $row['productName'] : '';
        $sellbillandrutern->sellAndReturnTotalPayed = isset($row['sellAndReturnTotalPayed']) ? $row['sellAndReturnTotalPayed'] : '';
        $sellbillandrutern->username = isset($row['username']) ? $row['username'] : '';
        $sellbillandrutern->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $sellbillandrutern->currencyId = isset($row['currencyId']) ? $row['currencyId'] : '';
        $sellbillandrutern->countsellbillandrutern = isset($row['countsellbillandrutern']) ? $row['countsellbillandrutern'] : '';


        $sellbillandrutern->delbyuserid = isset($row['delbyuserid']) ? $row['delbyuserid'] : '';

        $sellbillandrutern->billReservation = isset($row['billReservation']) ? $row['billReservation'] : '';
        $sellbillandrutern->billReservationDate = isset($row['billReservationDate']) ? $row['billReservationDate'] : '';
        $sellbillandrutern->visaAccountId = isset($row['visaAccountId']) ? $row['visaAccountId'] : '';
        $sellbillandrutern->cashPayed = isset($row['cashPayed']) ? $row['cashPayed'] : '';
        $sellbillandrutern->visaPayed = isset($row['visaPayed']) ? $row['visaPayed'] : '';
        $sellbillandrutern->isBankAccountTransfer = isset($row['isBankAccountTransfer']) ? $row['isBankAccountTransfer'] : '';
        $sellbillandrutern->extraDiscountPer = isset($row['extraDiscountPer']) ? $row['extraDiscountPer'] : '';
        $sellbillandrutern->extraDiscountVal = isset($row['extraDiscountVal']) ? $row['extraDiscountVal'] : '';
        $sellbillandrutern->taxOfDiscountPer = isset($row['taxOfDiscountPer']) ? $row['taxOfDiscountPer'] : '';
        $sellbillandrutern->taxOfDiscountVal = isset($row['taxOfDiscountVal']) ? $row['taxOfDiscountVal'] : '';
        $sellbillandrutern->autoSaveFlag = isset($row['autoSaveFlag']) ? $row['autoSaveFlag'] : '';
        $sellbillandrutern->obgyBillType = isset($row['obgyBillType']) ? $row['obgyBillType'] : '';
        $sellbillandrutern->billoperationid = isset($row['billoperationid']) ? $row['billoperationid'] : '';

        $sellbillandrutern->delbyusername = isset($row['delbyusername']) ? $row['delbyusername'] : '';
        $sellbillandrutern->sellbilldetailproductid = isset($row['sellbilldetailproductid']) ? $row['sellbilldetailproductid'] : '';
        $sellbillandrutern->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $sellbillandrutern->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $sellbillandrutern->areaName = isset($row['areaName']) ? $row['areaName'] : '';
        $sellbillandrutern->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';
        $sellbillandrutern->awardrate = isset($row['awardrate']) ? $row['awardrate'] : '';


        return $sellbillandrutern;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SellbillandruternMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>