<?php

/**
 * Class that operate on table 'returnbuybilldetail'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ReturnbuybilldetailMySqlDAO implements ReturnbuybilldetailDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ReturnbuybilldetailMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM returnbuybilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM returnbuybilldetail ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param returnbuybilldetail primary key
     */
    public function delete($returnbuybilldetailid) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($returnbuybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ReturnbuybilldetailMySql returnbuybilldetail
     */
    public function insert($returnbuybilldetail) {
        $sql = 'INSERT INTO returnbuybilldetail (Parcode, returnbuybillid, returnbuybilldetailcatid, returnbuybilldetailproductid, returnbuybilldetailquantity, returnbuybilldetailprice, returnbuybilldetailtotalprice, discountvalue, note, productunitid,lastbuyprice,meanbuyprice,lastbuyprice_withDiscount,meanbuyprice_withDiscount,otherdetailquantity,sizeid,colorid, returnbuybilldetailpriceC, returnbuybilldetailtotalpriceC, discountvalueC,discounttype,rowtaxval,rowtaxper,lastbuyprice_withTax,meanbuyprice_withTax) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnbuybilldetail->parcode);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybillid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailcatid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailproductid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailquantity);
        $sqlQuery->set($returnbuybilldetail->returnbuybilldetailprice);
        $sqlQuery->set($returnbuybilldetail->returnbuybilldetailtotalprice);
        $sqlQuery->set($returnbuybilldetail->discountvalue);
        $sqlQuery->set($returnbuybilldetail->note);
        $sqlQuery->setNumber($returnbuybilldetail->productunitid);
        $sqlQuery->set($returnbuybilldetail->lastbuyprice);
        $sqlQuery->set($returnbuybilldetail->meanbuyprice);
        $sqlQuery->set((float) $returnbuybilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $returnbuybilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber($returnbuybilldetail->otherdetailquantity);
        $sqlQuery->setNumber((int) $returnbuybilldetail->sizeid);
        $sqlQuery->setNumber((int) $returnbuybilldetail->colorid);
        $sqlQuery->setNumber((float) $returnbuybilldetail->returnbuybilldetailpriceC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->returnbuybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->discounttype);
        $sqlQuery->setNumber((float) $returnbuybilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $returnbuybilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $returnbuybilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnbuybilldetail->meanbuyprice_withTax);

        $id = $this->executeInsert($sqlQuery);
        $returnbuybilldetail->returnbuybilldetailid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ReturnbuybilldetailMySql returnbuybilldetail
     */
    public function update($returnbuybilldetail) {
        $sql = 'UPDATE returnbuybilldetail SET Parcode = ?, returnbuybillid = ?, returnbuybilldetailcatid = ?, returnbuybilldetailproductid = ?, returnbuybilldetailquantity = ?, returnbuybilldetailprice = ?, returnbuybilldetailtotalprice = ?, discountvalue = ?, note = ?, productunitid = ?,lastbuyprice = ?,meanbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice_withDiscount = ?,sizeid = ?,colorid= ?, returnbuybilldetailpriceC = ?, returnbuybilldetailtotalpriceC = ?, discountvalueC = ?,discounttype=?,rowtaxval=?,rowtaxper=?,lastbuyprice_withTax=?,meanbuyprice_withTax=? WHERE returnbuybilldetailid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($returnbuybilldetail->parcode);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybillid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailcatid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailproductid);
        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailquantity);
        $sqlQuery->set($returnbuybilldetail->returnbuybilldetailprice);
        $sqlQuery->set($returnbuybilldetail->returnbuybilldetailtotalprice);
        $sqlQuery->set($returnbuybilldetail->discountvalue);
        $sqlQuery->set($returnbuybilldetail->note);
        $sqlQuery->setNumber($returnbuybilldetail->productunitid);
        $sqlQuery->set($returnbuybilldetail->lastbuyprice);
        $sqlQuery->set($returnbuybilldetail->meanbuyprice);
        $sqlQuery->set((float) $returnbuybilldetail->lastbuyprice_withDiscount);
        $sqlQuery->set((float) $returnbuybilldetail->meanbuyprice_withDiscount);
        $sqlQuery->setNumber((int) $returnbuybilldetail->sizeid);
        $sqlQuery->setNumber((int) $returnbuybilldetail->colorid);
        $sqlQuery->setNumber((float) $returnbuybilldetail->returnbuybilldetailpriceC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->returnbuybilldetailtotalpriceC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->discountvalueC);
        $sqlQuery->setNumber((float) $returnbuybilldetail->discounttype);
        $sqlQuery->setNumber((float) $returnbuybilldetail->rowtaxval);
        $sqlQuery->setNumber((float) $returnbuybilldetail->rowtaxper);
        $sqlQuery->setNumber((float) $returnbuybilldetail->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $returnbuybilldetail->meanbuyprice_withTax);

        $sqlQuery->setNumber($returnbuybilldetail->returnbuybilldetailid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM returnbuybilldetail';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByParcode($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybillid($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldetailcatid($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldetailproductid($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldetailquantity($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldetailprice($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnbuybilldetailtotalprice($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE returnbuybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNote($value) {
        $sql = 'SELECT * FROM returnbuybilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByParcode($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE Parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybillid($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybillid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldetailcatid($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailcatid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldetailproductid($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldetailquantity($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailquantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldetailprice($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnbuybilldetailtotalprice($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE returnbuybilldetailtotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNote($value) {
        $sql = 'DELETE FROM returnbuybilldetail WHERE note = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ReturnbuybilldetailMySql
     */
    protected function readRow($row) {
        $returnbuybilldetail = new Returnbuybilldetail();

        $returnbuybilldetail->returnbuybilldetailid = isset($row['returnbuybilldetailid']) ? $row['returnbuybilldetailid'] : '';
        $returnbuybilldetail->parcode = isset($row['Parcode']) ? $row['Parcode'] : '';
        $returnbuybilldetail->returnbuybillid = isset($row['returnbuybillid']) ? $row['returnbuybillid'] : '';
        $returnbuybilldetail->returnbuybilldetailcatid = isset($row['returnbuybilldetailcatid']) ? $row['returnbuybilldetailcatid'] : '';
        $returnbuybilldetail->returnbuybilldetailproductid = isset($row['returnbuybilldetailproductid']) ? $row['returnbuybilldetailproductid'] : '';
        $returnbuybilldetail->returnbuybilldetailquantity = isset($row['returnbuybilldetailquantity']) ? $row['returnbuybilldetailquantity'] : '';
        $returnbuybilldetail->returnbuybilldetailprice = isset($row['returnbuybilldetailprice']) ? $row['returnbuybilldetailprice'] : '';
        $returnbuybilldetail->returnbuybilldetailtotalprice = isset($row['returnbuybilldetailtotalprice']) ? $row['returnbuybilldetailtotalprice'] : '';
        $returnbuybilldetail->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $returnbuybilldetail->note = isset($row['note']) ? $row['note'] : '';
        $returnbuybilldetail->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';

        $returnbuybilldetail->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $returnbuybilldetail->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $returnbuybilldetail->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $returnbuybilldetail->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $returnbuybilldetail->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $returnbuybilldetail->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $returnbuybilldetail->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $returnbuybilldetail->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $returnbuybilldetail->returnbuybilldetailpriceC = isset($row['returnbuybilldetailpriceC']) ? $row['returnbuybilldetailpriceC'] : '';
        $returnbuybilldetail->returnbuybilldetailtotalpriceC = isset($row['returnbuybilldetailtotalpriceC']) ? $row['returnbuybilldetailtotalpriceC'] : '';
        $returnbuybilldetail->discountvalueC = isset($row['discountvalueC']) ? $row['discountvalueC'] : '';
        $returnbuybilldetail->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $returnbuybilldetail->rowtaxval = isset($row['rowtaxval']) ? $row['rowtaxval'] : '';
        $returnbuybilldetail->rowtaxper = isset($row['rowtaxper']) ? $row['rowtaxper'] : '';

        //required
        $returnbuybilldetail->productName = isset($row['productName']) ? $row['productName'] : '';
        $returnbuybilldetail->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $returnbuybilldetail->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $returnbuybilldetail->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $returnbuybilldetail->totalQty = isset($row['totalQty']) ? $row['totalQty'] : '';
        $returnbuybilldetail->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';
        $returnbuybilldetail->otherdetailquantity = isset($row['otherdetailquantity']) ? $row['otherdetailquantity'] : '';
        $returnbuybilldetail->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';

        $returnbuybilldetail->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $returnbuybilldetail->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $returnbuybilldetail->logo = isset($row['logo']) ? $row['logo'] : '';

        return $returnbuybilldetail;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ReturnbuybilldetailMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>