<?php

/**
 * Class that operate on table 'rentbill'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-08-17 10:05
 */
class RentbillMySqlDAO implements RentbillDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RentbillMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM rentbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM rentbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM rentbill ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param rentbill primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM rentbill WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RentbillMySql rentbill
     */
    public function insert($rentbill) {
        $sql = 'INSERT INTO rentbill (clientid, createdatetime, billtotal, firmbilltotal, billpayed, billreset,dailyentryid,payistype,bankid,accountid,paperno,paperval,paperdate,discount,distotal) VALUES (?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentbill->clientid);
        $sqlQuery->set($rentbill->createdatetime);
        $sqlQuery->set($rentbill->billtotal);
        $sqlQuery->set($rentbill->firmbilltotal);
        $sqlQuery->set($rentbill->billpayed);
        $sqlQuery->set($rentbill->billreset);
        $sqlQuery->setNumber($rentbill->dailyentryid);

        $sqlQuery->set($rentbill->payistype);
        $sqlQuery->set($rentbill->bankid);
        $sqlQuery->set($rentbill->accountid);
        $sqlQuery->set($rentbill->paperno);
        $sqlQuery->set($rentbill->paperval);
        $sqlQuery->set($rentbill->paperdate);
        $sqlQuery->set($rentbill->discount);
        $sqlQuery->set($rentbill->distotal);


        $id = $this->executeInsert($sqlQuery);
        $rentbill->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RentbillMySql rentbill
     */
    public function update($rentbill) {
        $sql = 'UPDATE rentbill SET clientid = ?, createdatetime = ?, billtotal = ?, firmbilltotal = ?, billpayed = ?, billreset = ? , dailyentryid = ?,discount = ?,distotal = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($rentbill->clientid);
        $sqlQuery->set($rentbill->createdatetime);
        $sqlQuery->set($rentbill->billtotal);
        $sqlQuery->set($rentbill->firmbilltotal);
        $sqlQuery->set($rentbill->billpayed);
        $sqlQuery->set($rentbill->billreset);
        $sqlQuery->setNumber($rentbill->dailyentryid);
        $sqlQuery->set($rentbill->discount);
        $sqlQuery->set($rentbill->distotal);

        $sqlQuery->setNumber($rentbill->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM rentbill';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM rentbill WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCreatedatetime($value) {
        $sql = 'SELECT * FROM rentbill WHERE createdatetime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBilltotal($value) {
        $sql = 'SELECT * FROM rentbill WHERE billtotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFirmbilltotal($value) {
        $sql = 'SELECT * FROM rentbill WHERE firmbilltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillpayed($value) {
        $sql = 'SELECT * FROM rentbill WHERE billpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillreset($value) {
        $sql = 'SELECT * FROM rentbill WHERE billreset = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM rentbill WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCreatedatetime($value) {
        $sql = 'DELETE FROM rentbill WHERE createdatetime = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBilltotal($value) {
        $sql = 'DELETE FROM rentbill WHERE billtotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFirmbilltotal($value) {
        $sql = 'DELETE FROM rentbill WHERE firmbilltotal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillpayed($value) {
        $sql = 'DELETE FROM rentbill WHERE billpayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillreset($value) {
        $sql = 'DELETE FROM rentbill WHERE billreset = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RentbillMySql
     */
    protected function readRow($row) {
        $rentbill = new Rentbill();

        $rentbill->id = isset($row['id']) ? $row['id'] : '';
        $rentbill->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $rentbill->createdatetime = isset($row['createdatetime']) ? $row['createdatetime'] : '';
        $rentbill->billtotal = isset($row['billtotal']) ? $row['billtotal'] : '';
        $rentbill->firmbilltotal = isset($row['firmbilltotal']) ? $row['firmbilltotal'] : '';
        $rentbill->billpayed = isset($row['billpayed']) ? $row['billpayed'] : '';
        $rentbill->billreset = isset($row['billreset']) ? $row['billreset'] : '';
        $rentbill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';

        $rentbill->payistype = isset($row['payistype']) ? $row['payistype'] : '';
        $rentbill->bankid = isset($row['bankid']) ? $row['bankid'] : '';
        $rentbill->accountid = isset($row['accountid']) ? $row['accountid'] : '';
        $rentbill->paperno = isset($row['paperno']) ? $row['paperno'] : '';
        $rentbill->paperval = isset($row['paperval']) ? $row['paperval'] : '';
        $rentbill->paperdate = isset($row['paperdate']) ? $row['paperdate'] : '';
        $rentbill->discount = isset($row['discount']) ? $row['discount'] : '';
        $rentbill->distotal = isset($row['distotal']) ? $row['distotal'] : '';

        return $rentbill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RentbillMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>