<?php

/**
 * Class that operate on table 'relusergroupproperties'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class RelusergrouppropertiesMySqlDAO implements RelusergrouppropertiesDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return RelusergrouppropertiesMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM relusergroupproperties WHERE relusergrouppropertiesid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM relusergroupproperties';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM relusergroupproperties ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param relusergrouppropertie primary key
     */
    public function delete($relusergrouppropertiesid) {
        $sql = 'DELETE FROM relusergroupproperties WHERE relusergrouppropertiesid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($relusergrouppropertiesid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param RelusergrouppropertiesMySql relusergrouppropertie
     */
    public function insert($relusergrouppropertie) {
        $sql = 'INSERT INTO relusergroupproperties (usergroupid, propertyid, propertyvalue,theorder) VALUES (?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($relusergrouppropertie->usergroupid);
        $sqlQuery->setNumber($relusergrouppropertie->propertyid);
        $sqlQuery->setNumber($relusergrouppropertie->propertyvalue);
        $sqlQuery->setNumber((int) $relusergrouppropertie->theorder);

        $id = $this->executeInsert($sqlQuery);
        $relusergrouppropertie->relusergrouppropertiesid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param RelusergrouppropertiesMySql relusergrouppropertie
     */
    public function update($relusergrouppropertie) {
        $sql = 'UPDATE relusergroupproperties SET usergroupid = ?, propertyid = ?, propertyvalue = ?,theorder = ? WHERE relusergrouppropertiesid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($relusergrouppropertie->usergroupid);
        $sqlQuery->setNumber($relusergrouppropertie->propertyid);
        $sqlQuery->setNumber($relusergrouppropertie->propertyvalue);
        $sqlQuery->setNumber((int) $relusergrouppropertie->theorder);

        $sqlQuery->setNumber($relusergrouppropertie->relusergrouppropertiesid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM relusergroupproperties';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByUsergroupid($value) {
        $sql = 'SELECT * FROM relusergroupproperties WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyid($value) {
        $sql = 'SELECT * FROM relusergroupproperties WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPropertyvalue($value) {
        $sql = 'SELECT * FROM relusergroupproperties WHERE propertyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByUsergroupid($value) {
        $sql = 'DELETE FROM relusergroupproperties WHERE usergroupid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyid($value) {
        $sql = 'DELETE FROM relusergroupproperties WHERE propertyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPropertyvalue($value) {
        $sql = 'DELETE FROM relusergroupproperties WHERE propertyvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return RelusergrouppropertiesMySql
     */
    protected function readRow($row) {
        $relusergrouppropertie = new Relusergrouppropertie();

        $relusergrouppropertie->relusergrouppropertiesid = isset($row['relusergrouppropertiesid']) ? $row['relusergrouppropertiesid'] : '';
        $relusergrouppropertie->usergroupid = isset($row['usergroupid']) ? $row['usergroupid'] : '';
        $relusergrouppropertie->propertyid = isset($row['propertyid']) ? $row['propertyid'] : '';
        $relusergrouppropertie->propertyvalue = isset($row['propertyvalue']) ? $row['propertyvalue'] : '';
        $relusergrouppropertie->theorder = isset($row['theorder']) ? $row['theorder'] : '';

        //required
        $relusergrouppropertie->propertyname = isset($row['propertyname']) ? $row['propertyname'] : '';
        $relusergrouppropertie->propertyurl = isset($row['propertyurl']) ? $row['propertyurl'] : '';
        $relusergrouppropertie->propertyparent = isset($row['propertyparent']) ? $row['propertyparent'] : '';
        $relusergrouppropertie->isallowed = isset($row['isallowed']) ? $row['isallowed'] : '';

        return $relusergrouppropertie;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return RelusergrouppropertiesMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>