<?php

/**
 * Class that operate on table 'purchasebillreturns'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class PurchasebillreturnsMySqlDAO implements PurchasebillreturnsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return PurchasebillreturnsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM purchasebillreturns';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM purchasebillreturns ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param purchasebillreturn primary key
     */
    public function delete($purchasebillreturnid) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($purchasebillreturnid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param PurchasebillreturnsMySql purchasebillreturn
     */
    public function insert($purchasebillreturn) {
        $sql = 'INSERT INTO purchasebillreturns (rawmaterialssupplierid, purchasebillreturnsdate, rawmaterialssupplierdebtbefore, rawmaterialssupplierdebtafter, storerawmaterialid, purchasebillreturnstotalbeforediscount, purchasebillreturnsdiscount, purchasebillreturnspayed, purchasebillreturnstotalafterdiscount, tempdelete) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($purchasebillreturn->rawmaterialssupplierid);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnsdate);
        $sqlQuery->set($purchasebillreturn->rawmaterialssupplierdebtbefore);
        $sqlQuery->set($purchasebillreturn->rawmaterialssupplierdebtafter);
        $sqlQuery->setNumber($purchasebillreturn->storerawmaterialid);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnstotalbeforediscount);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnsdiscount);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnspayed);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnstotalafterdiscount);
        $sqlQuery->setNumber($purchasebillreturn->tempdelete);

        $id = $this->executeInsert($sqlQuery);
        $purchasebillreturn->purchasebillreturnid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param PurchasebillreturnsMySql purchasebillreturn
     */
    public function update($purchasebillreturn) {
        $sql = 'UPDATE purchasebillreturns SET rawmaterialssupplierid = ?, purchasebillreturnsdate = ?, rawmaterialssupplierdebtbefore = ?, rawmaterialssupplierdebtafter = ?, storerawmaterialid = ?, purchasebillreturnstotalbeforediscount = ?, purchasebillreturnsdiscount = ?, purchasebillreturnspayed = ?, purchasebillreturnstotalafterdiscount = ?, tempdelete = ? WHERE purchasebillreturnid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($purchasebillreturn->rawmaterialssupplierid);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnsdate);
        $sqlQuery->set($purchasebillreturn->rawmaterialssupplierdebtbefore);
        $sqlQuery->set($purchasebillreturn->rawmaterialssupplierdebtafter);
        $sqlQuery->setNumber($purchasebillreturn->storerawmaterialid);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnstotalbeforediscount);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnsdiscount);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnspayed);
        $sqlQuery->set($purchasebillreturn->purchasebillreturnstotalafterdiscount);
        $sqlQuery->setNumber($purchasebillreturn->tempdelete);

        $sqlQuery->setNumber($purchasebillreturn->purchasebillreturnid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM purchasebillreturns';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByRawmaterialssupplierid($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillreturnsdate($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnsdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplierdebtbefore($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE rawmaterialssupplierdebtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRawmaterialssupplierdebtafter($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE rawmaterialssupplierdebtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStorerawmaterialid($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE storerawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillreturnstotalbeforediscount($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnstotalbeforediscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillreturnsdiscount($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnsdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillreturnspayed($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnspayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPurchasebillreturnstotalafterdiscount($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE purchasebillreturnstotalafterdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM purchasebillreturns WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByRawmaterialssupplierid($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE rawmaterialssupplierid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillreturnsdate($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnsdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplierdebtbefore($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE rawmaterialssupplierdebtbefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRawmaterialssupplierdebtafter($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE rawmaterialssupplierdebtafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStorerawmaterialid($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE storerawmaterialid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillreturnstotalbeforediscount($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnstotalbeforediscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillreturnsdiscount($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnsdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillreturnspayed($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnspayed = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPurchasebillreturnstotalafterdiscount($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE purchasebillreturnstotalafterdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM purchasebillreturns WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return PurchasebillreturnsMySql
     */
    protected function readRow($row) {
        $purchasebillreturn = new Purchasebillreturn();

        $purchasebillreturn->purchasebillreturnid = isset($row['purchasebillreturnid']) ? $row['purchasebillreturnid'] : '';
        $purchasebillreturn->rawmaterialssupplierid = isset($row['rawmaterialssupplierid']) ? $row['rawmaterialssupplierid'] : '';
        $purchasebillreturn->purchasebillreturnsdate = isset($row['purchasebillreturnsdate']) ? $row['purchasebillreturnsdate'] : '';
        $purchasebillreturn->rawmaterialssupplierdebtbefore = isset($row['rawmaterialssupplierdebtbefore']) ? $row['rawmaterialssupplierdebtbefore'] : '';
        $purchasebillreturn->rawmaterialssupplierdebtafter = isset($row['rawmaterialssupplierdebtafter']) ? $row['rawmaterialssupplierdebtafter'] : '';
        $purchasebillreturn->storerawmaterialid = isset($row['storerawmaterialid']) ? $row['storerawmaterialid'] : '';
        $purchasebillreturn->purchasebillreturnstotalbeforediscount = isset($row['purchasebillreturnstotalbeforediscount']) ? $row['purchasebillreturnstotalbeforediscount'] : '';
        $purchasebillreturn->purchasebillreturnsdiscount = isset($row['purchasebillreturnsdiscount']) ? $row['purchasebillreturnsdiscount'] : '';
        $purchasebillreturn->purchasebillreturnspayed = isset($row['purchasebillreturnspayed']) ? $row['purchasebillreturnspayed'] : '';
        $purchasebillreturn->purchasebillreturnstotalafterdiscount = isset($row['purchasebillreturnstotalafterdiscount']) ? $row['purchasebillreturnstotalafterdiscount'] : '';
        $purchasebillreturn->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';

        return $purchasebillreturn;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return PurchasebillreturnsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>