<?php

/**
 * Class that operate on table 'productrequests'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-10-16 10:57
 */
class ProductrequestsMySqlDAO implements ProductrequestsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductrequestsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productrequests WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productrequests';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productrequests ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productrequest primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productrequests WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductrequestsMySql productrequest
     */
    public function insert($productrequest) {
        $sql = 'INSERT INTO productrequests (productid, storeid, requeststoreid, productnoreq, productnoaccept, useridadd, useridresponse, status,seen , deleted) VALUES (?,?,?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productrequest->productid);
        $sqlQuery->setNumber($productrequest->storeid);
        $sqlQuery->setNumber($productrequest->requeststoreid);
        $sqlQuery->setNumber($productrequest->productnoreq);
        $sqlQuery->setNumber($productrequest->productnoaccept);
        $sqlQuery->setNumber($productrequest->useridadd);
        $sqlQuery->setNumber($productrequest->useridresponse);
        $sqlQuery->setNumber($productrequest->status);
        $sqlQuery->setNumber($productrequest->seen);
        $sqlQuery->setNumber($productrequest->deleted);

        $id = $this->executeInsert($sqlQuery);
        $productrequest->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductrequestsMySql productrequest
     */
    public function update($productrequest) {
        $sql = 'UPDATE productrequests SET productid = ?, storeid = ?, requeststoreid = ? , productnoreq = ?, productnoaccept = ?, useridadd = ?, useridresponse = ?, status = ?,seen = ? , deleted = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productrequest->productid);
        $sqlQuery->setNumber($productrequest->storeid);
        $sqlQuery->setNumber($productrequest->requeststoreid);
        $sqlQuery->setNumber($productrequest->productnoreq);
        $sqlQuery->setNumber($productrequest->productnoaccept);
        $sqlQuery->setNumber($productrequest->useridadd);
        $sqlQuery->setNumber($productrequest->useridresponse);
        $sqlQuery->setNumber($productrequest->status);
        $sqlQuery->setNumber($productrequest->seen);
        $sqlQuery->setNumber($productrequest->deleted);

        $sqlQuery->setNumber($productrequest->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productrequests';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductid($value) {
        $sql = 'SELECT * FROM productrequests WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreid($value) {
        $sql = 'SELECT * FROM productrequests WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductnoreq($value) {
        $sql = 'SELECT * FROM productrequests WHERE productnoreq = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductnoaccept($value) {
        $sql = 'SELECT * FROM productrequests WHERE productnoaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUseridadd($value) {
        $sql = 'SELECT * FROM productrequests WHERE useridadd = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUseridresponse($value) {
        $sql = 'SELECT * FROM productrequests WHERE useridresponse = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStatus($value) {
        $sql = 'SELECT * FROM productrequests WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM productrequests WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductid($value) {
        $sql = 'DELETE FROM productrequests WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreid($value) {
        $sql = 'DELETE FROM productrequests WHERE storeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductnoreq($value) {
        $sql = 'DELETE FROM productrequests WHERE productnoreq = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductnoaccept($value) {
        $sql = 'DELETE FROM productrequests WHERE productnoaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUseridadd($value) {
        $sql = 'DELETE FROM productrequests WHERE useridadd = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUseridresponse($value) {
        $sql = 'DELETE FROM productrequests WHERE useridresponse = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStatus($value) {
        $sql = 'DELETE FROM productrequests WHERE status = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM productrequests WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductrequestsMySql
     */
    protected function readRow($row) {
        $productrequest = new Productrequest();

        $productrequest->id = isset($row['id']) ? $row['id'] : '';
        $productrequest->productid = isset($row['productid']) ? $row['productid'] : '';
        $productrequest->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $productrequest->requeststoreid = isset($row['requeststoreid']) ? $row['requeststoreid'] : '';
        $productrequest->productnoreq = isset($row['productnoreq']) ? $row['productnoreq'] : '';
        $productrequest->productnoaccept = isset($row['productnoaccept']) ? $row['productnoaccept'] : '';
        $productrequest->useridadd = isset($row['useridadd']) ? $row['useridadd'] : '';
        $productrequest->useridresponse = isset($row['useridresponse']) ? $row['useridresponse'] : '';
        $productrequest->status = isset($row['status']) ? $row['status'] : '';
        $productrequest->seen = isset($row['seen']) ? $row['seen'] : '';
        $productrequest->deleted = isset($row['deleted']) ? $row['deleted'] : '';

        $productrequest->requestStoreName = isset($row['requestStoreName']) ? $row['requestStoreName'] : '';
        $productrequest->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $productrequest->productName = isset($row['productName']) ? $row['productName'] : '';
        $productrequest->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';

        return $productrequest;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductrequestsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>