<?php

/**
 * Class that operate on table 'productionrateproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
class ProductionrateproductMySqlDAO implements ProductionrateproductDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductionrateproductMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productionrateproduct WHERE productionRateProductId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productionrateproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productionrateproduct ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productionrateproduct primary key
     */
    public function delete($productionRateProductId) {
        $sql = 'DELETE FROM productionrateproduct WHERE productionRateProductId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productionRateProductId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductionrateproductMySql productionrateproduct
     */
    public function insert($productionrateproduct) {
        $sql = 'INSERT INTO productionrateproduct (productionRateId, productId, unitId, rate, quantity, userId, thedate, conditions,sizeid,colorid) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionrateproduct->productionRateId);
        $sqlQuery->setNumber($productionrateproduct->productId);
        $sqlQuery->setNumber($productionrateproduct->unitId);
        $sqlQuery->set($productionrateproduct->rate);
        $sqlQuery->set($productionrateproduct->quantity);
        $sqlQuery->setNumber($productionrateproduct->userId);
        $sqlQuery->set($productionrateproduct->thedate);
        $sqlQuery->setNumber($productionrateproduct->conditions);
        $sqlQuery->setNumber((int) $productionrateproduct->sizeid);
        $sqlQuery->setNumber((int) $productionrateproduct->colorid);

        $id = $this->executeInsert($sqlQuery);
        $productionrateproduct->productionRateProductId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductionrateproductMySql productionrateproduct
     */
    public function update($productionrateproduct) {
        $sql = 'UPDATE productionrateproduct SET productionRateId = ?, productId = ?, unitId = ?, rate = ?, quantity = ?, userId = ?, thedate = ?, conditions = ?,sizeid=?,colorid=? WHERE productionRateProductId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionrateproduct->productionRateId);
        $sqlQuery->setNumber($productionrateproduct->productId);
        $sqlQuery->setNumber($productionrateproduct->unitId);
        $sqlQuery->set($productionrateproduct->rate);
        $sqlQuery->set($productionrateproduct->quantity);
        $sqlQuery->setNumber($productionrateproduct->userId);
        $sqlQuery->set($productionrateproduct->thedate);
        $sqlQuery->setNumber($productionrateproduct->conditions);
        $sqlQuery->setNumber((int) $productionrateproduct->sizeid);
        $sqlQuery->setNumber((int) $productionrateproduct->colorid);

        $sqlQuery->setNumber($productionrateproduct->productionRateProductId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productionrateproduct';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductionRateId($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE productionRateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRate($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE rate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM productionrateproduct WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductionRateId($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE productionRateId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRate($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE rate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM productionrateproduct WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductionrateproductMySql
     */
    protected function readRow($row) {

        $productionrateproduct->productionRateProductId = isset($row['productionRateProductId']) ? $row['productionRateProductId'] : '';
        $productionrateproduct->productionRateId = isset($row['productionRateId']) ? $row['productionRateId'] : '';
        $productionrateproduct->productId = isset($row['productId']) ? $row['productId'] : '';
        $productionrateproduct->unitId = isset($row['unitId']) ? $row['unitId'] : '';
        $productionrateproduct->rate = isset($row['rate']) ? $row['rate'] : '';
        $productionrateproduct->quantity = isset($row['quantity']) ? (float) $row['quantity'] : '';
        $productionrateproduct->userId = isset($row['userId']) ? $row['userId'] : '';
        $productionrateproduct->thedate = isset($row['thedate']) ? $row['thedate'] : '';
        $productionrateproduct->condition = isset($row['conditions']) ? $row['conditions'] : '';
        $productionrateproduct->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $productionrateproduct->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        //
        $productionrateproduct->productName = isset($row['productName']) ? $row['productName'] : '';
        $productionrateproduct->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $productionrateproduct->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $productionrateproduct->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $productionrateproduct->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $productionrateproduct->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $productionrateproduct->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $productionrateproduct->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $productionrateproduct->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $productionrateproduct->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $productionrateproduct->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';


        return $productionrateproduct;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductionrateproductMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>