<?php

/**
 * Class that operate on table 'productingredients'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-04-04 07:27
 */
class ProductingredientsMySqlDAO implements ProductingredientsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductingredientsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM productingredients WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM productingredients';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM productingredients ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param productingredient primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM productingredients WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductingredientsMySql productingredient
     */
    public function insert($productingredient) {
        $sql = 'INSERT INTO productingredients (productId, ingridientId, unitId, quantity, userId, thedate, conditions) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productingredient->productId);
        $sqlQuery->setNumber($productingredient->ingridientId);
        $sqlQuery->setNumber($productingredient->unitId);
        $sqlQuery->set($productingredient->quantity);
        $sqlQuery->setNumber($productingredient->userId);
        $sqlQuery->set($productingredient->thedate);
        $sqlQuery->setNumber($productingredient->conditions);

        $id = $this->executeInsert($sqlQuery);
        $productingredient->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductingredientsMySql productingredient
     */
    public function update($productingredient) {
        $sql = 'UPDATE productingredients SET productId = ?, ingridientId = ?, unitId = ?, quantity = ?, userId = ?, thedate = ?, conditions = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productingredient->productId);
        $sqlQuery->setNumber($productingredient->ingridientId);
        $sqlQuery->setNumber($productingredient->unitId);
        $sqlQuery->set($productingredient->quantity);
        $sqlQuery->setNumber($productingredient->userId);
        $sqlQuery->set($productingredient->thedate);
        $sqlQuery->setNumber($productingredient->conditions);

        $sqlQuery->setNumber($productingredient->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM productingredients';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductId($value) {
        $sql = 'SELECT * FROM productingredients WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByIngridientId($value) {
        $sql = 'SELECT * FROM productingredients WHERE ingridientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUnitId($value) {
        $sql = 'SELECT * FROM productingredients WHERE unitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByQuantity($value) {
        $sql = 'SELECT * FROM productingredients WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM productingredients WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByThedate($value) {
        $sql = 'SELECT * FROM productingredients WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM productingredients WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductId($value) {
        $sql = 'DELETE FROM productingredients WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByIngridientId($value) {
        $sql = 'DELETE FROM productingredients WHERE ingridientId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUnitId($value) {
        $sql = 'DELETE FROM productingredients WHERE unitId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByQuantity($value) {
        $sql = 'DELETE FROM productingredients WHERE quantity = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM productingredients WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByThedate($value) {
        $sql = 'DELETE FROM productingredients WHERE thedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM productingredients WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductingredientsMySql
     */
    protected function readRow($row) {
        $productingredient = new Productingredient();

        $productingredient->id = $row['id'];
        $productingredient->productId = $row['productId'];
        $productingredient->ingridientId = $row['ingridientId'];
        $productingredient->unitId = $row['unitId'];
        $productingredient->quantity = $row['quantity'];
        $productingredient->userId = $row['userId'];
        $productingredient->thedate = $row['thedate'];
        $productingredient->conditions = $row['conditions'];

        $productingredient->productName = isset($row['productName']) ? $row['productName'] : '';
        $productingredient->unitName = isset($row['unitName']) ? $row['unitName'] : '';
        $productingredient->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $productingredient->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $productingredient->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $productingredient->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $productingredient->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $productingredient->productnumber = isset($row['productnumber']) ? $row['productnumber'] : '';

        return $productingredient;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductingredientsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>