<?php

/**
 * Class that operate on table 'product'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ProductMySqlDAO implements ProductDAO
{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ProductMySql
     */
    public function load($id)
    {
        $sql = 'SELECT * FROM product WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll()
    {
        $sql = 'SELECT * FROM product';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn)
    {
        $sql = 'SELECT * FROM product ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param product primary key
     */
    public function delete($productId)
    {
        $sql = 'DELETE FROM product WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($productId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ProductMySql product
     */
    public function insert($product)
    {
        $sql = 'INSERT INTO product (productName, productDescription, productCatId, productBuyPrice, productSellAllPrice, productSellUnitPrice, productSellHalfPrice, productDate, conditions, userId, limitamount, parcode,type, expireDate, dailyentryId,isService,isOptic,lastbuyprice,lastbuyprice_withDiscount,meanbuyprice,meanbuyprice_withDiscount , productbuypricereal , buypricereal_precentage , buytotal_precentage , buyhalf_precentage , buypart_precentage,logo,inMenu,obygyDetectionId,hasSizeAndColor,overAllAveragePrice,reviewType,online,updatebyuser,proExcelid,proExcelParcode,webApiId,runquery,weightedDiscount,sortby,obygyInvestigationId,TypeOfBarcodeInTax,barcodeInTax,productNameE,partNumber,vehicleType,company,weight,origin,hscode,power,ProductionDate,expiry,procode,lastbuyprice_withTax,meanbuyprice_withTax,price4,price5,price6,price7,price8,clientid) VALUES (?,?,?,?,?, ?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($product->productName);
        $sqlQuery->setString2($product->productDescription);
        $sqlQuery->setNumber($product->productCatId);
        $sqlQuery->set($product->productBuyPrice);
        $sqlQuery->set($product->productSellAllPrice);
        $sqlQuery->set($product->productSellUnitPrice);
        $sqlQuery->set($product->productSellHalfPrice);
        $sqlQuery->set($product->productDate);
        $sqlQuery->setNumber($product->conditions);
        $sqlQuery->setNumber($product->userId);
        $sqlQuery->setNumber($product->limitamount);
        $sqlQuery->set($product->parcode);
        $sqlQuery->setNumber($product->type);
        $sqlQuery->setNumber($product->expireDate);

        $sqlQuery->setNumber($product->dailyentryId);
        $sqlQuery->setNumber($product->isService);
        $sqlQuery->setNumber($product->isOptic);
        $sqlQuery->set($product->lastbuyprice);
        $sqlQuery->set((float) $product->lastbuyprice_withDiscount);
        $sqlQuery->set($product->meanbuyprice);
        $sqlQuery->set((float) $product->meanbuyprice_withDiscount);
        $sqlQuery->set($product->productbuypricereal);
        $sqlQuery->set($product->buypricereal_precentage);
        $sqlQuery->set($product->buytotal_precentage);
        $sqlQuery->set($product->buyhalf_precentage);
        $sqlQuery->set($product->buypart_precentage);
        $sqlQuery->set($product->logo);
        $sqlQuery->setNumber($product->inMenu);
        $sqlQuery->setNumber((int) $product->obygyDetectionId);
        $sqlQuery->setNumber((int) $product->hasSizeAndColor);
        $sqlQuery->setNumber((float) $product->overAllAveragePrice);
        $sqlQuery->setNumber((int) $product->reviewType);
        $sqlQuery->set($product->online);
        $sqlQuery->set($product->updatebyuser);
        $sqlQuery->setNumber((int) $product->proExcelid);
        $sqlQuery->setNumber((int) $product->proExcelParcode);
        $sqlQuery->setNumber((int) $product->webApiId);
        $sqlQuery->set($product->runquery);
        $sqlQuery->setNumber((float) $product->weightedDiscount);
        $sqlQuery->setNumber((int) $product->sortby);
        $sqlQuery->setNumber((int) $product->obygyInvestigationId);
        $sqlQuery->set($product->TypeOfBarcodeInTax);
        $sqlQuery->set($product->barcodeInTax);
        $sqlQuery->set($product->productNameE);
        $sqlQuery->setNumber((int) $product->partNumber);
        $sqlQuery->setNumber((int) $product->vehicleType);
        $sqlQuery->setNumber((int) $product->company);
        $sqlQuery->setNumber((int) $product->weight);
        $sqlQuery->set($product->origin);
        $sqlQuery->setNumber((int) $product->hscode);
        $sqlQuery->setNumber((int) $product->power);
        $sqlQuery->set($product->ProductionDate);
        $sqlQuery->setNumber((int) $product->expiry);
        $sqlQuery->set($product->procode);
        $sqlQuery->setNumber((float) $product->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $product->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $product->price4);
        $sqlQuery->setNumber((float) $product->price5);
        $sqlQuery->setNumber((float) $product->price6);
        $sqlQuery->setNumber((float) $product->price7);
        $sqlQuery->setNumber((float) $product->price8);
        $sqlQuery->setNumber((int) $product->clientid);


        $id = $this->executeInsert($sqlQuery);
        $product->productId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ProductMySql product
     */
    public function update($product)
    {
        $sql = 'UPDATE product SET productName = ?, productDescription = ?, productCatId = ?, productBuyPrice = ?, productSellAllPrice = ?, productSellUnitPrice = ?, productSellHalfPrice = ?, productDate = ?, conditions = ?, userId = ?, limitamount = ?, parcode = ?,type =?, expireDate = ? , dailyentryId = ?,isService = ?,isOptic = ?,lastbuyprice = ?,lastbuyprice_withDiscount = ?,meanbuyprice = ?,meanbuyprice_withDiscount = ? , productbuypricereal = ? , buypricereal_precentage = ? , buytotal_precentage = ? , buyhalf_precentage = ? , buypart_precentage = ?,logo = ?,inMenu=?, obygyDetectionId = ?,hasSizeAndColor = ?,overAllAveragePrice=?,logo1 = ?,logo2 = ?,logo3 = ?,logo4 = ?,logo5 = ?,logo6 = ?,logo7 = ?,reviewType =? , online = ? , updatebyuser = ?,weightedDiscount=?,sortby=?,TypeOfBarcodeInTax=?,barcodeInTax=?,productNameE=?,partNumber=?,vehicleType=?,company=?,weight=?,origin=?,hscode=?,power=?,ProductionDate=?,expiry=?,procode=?,lastbuyprice_withTax=?,meanbuyprice_withTax=?,price4=?,price5=?,price6=?,price7=?,price8=?,clientid=?  WHERE productId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($product->productName);
        $sqlQuery->setString2($product->productDescription);
        $sqlQuery->setNumber($product->productCatId);
        $sqlQuery->set($product->productBuyPrice);
        $sqlQuery->set($product->productSellAllPrice);
        $sqlQuery->set($product->productSellUnitPrice);
        $sqlQuery->set($product->productSellHalfPrice);
        $sqlQuery->set($product->productDate);
        $sqlQuery->setNumber($product->conditions);
        $sqlQuery->setNumber($product->userId);
        $sqlQuery->setNumber($product->limitamount);
        $sqlQuery->set($product->parcode);
        $sqlQuery->setNumber($product->type);
        $sqlQuery->setNumber((int) $product->expireDate);
        $sqlQuery->setNumber($product->dailyentryId);
        $sqlQuery->setNumber($product->isService);
        $sqlQuery->setNumber($product->isOptic);
        $sqlQuery->set($product->lastbuyprice);
        $sqlQuery->set((float) $product->lastbuyprice_withDiscount);
        $sqlQuery->set($product->meanbuyprice);
        $sqlQuery->set((float) $product->meanbuyprice_withDiscount);
        $sqlQuery->set($product->productbuypricereal);
        $sqlQuery->set($product->buypricereal_precentage);
        $sqlQuery->set($product->buytotal_precentage);
        $sqlQuery->set($product->buyhalf_precentage);
        $sqlQuery->set($product->buypart_precentage);
        $sqlQuery->set($product->logo);
        $sqlQuery->setNumber((int) $product->inMenu);
        $sqlQuery->setNumber((int) $product->obygyDetectionId);
        $sqlQuery->setNumber((int) $product->hasSizeAndColor);
        $sqlQuery->setNumber((float) $product->overAllAveragePrice);
        $sqlQuery->set($product->logo1);
        $sqlQuery->set($product->logo2);
        $sqlQuery->set($product->logo3);
        $sqlQuery->set($product->logo4);
        $sqlQuery->set($product->logo5);
        $sqlQuery->set($product->logo6);
        $sqlQuery->set($product->logo7);
        $sqlQuery->setNumber($product->reviewType);
        $sqlQuery->set($product->online);
        $sqlQuery->set($product->updatebyuser);
        $sqlQuery->setNumber((float) $product->weightedDiscount);
        $sqlQuery->setNumber($product->sortby);
        $sqlQuery->set($product->TypeOfBarcodeInTax);
        $sqlQuery->set($product->barcodeInTax);
        $sqlQuery->set($product->productNameE);
        $sqlQuery->setNumber((int) $product->partNumber);
        $sqlQuery->setNumber((int) $product->vehicleType);
        $sqlQuery->setNumber((int) $product->company);
        $sqlQuery->setNumber((int) $product->weight);
        $sqlQuery->set($product->origin);
        $sqlQuery->setNumber((int) $product->hscode);
        $sqlQuery->setNumber((int) $product->power);
        $sqlQuery->set($product->ProductionDate);
        $sqlQuery->setNumber((int) $product->expiry);
        $sqlQuery->set($product->procode);
        $sqlQuery->setNumber((float) $product->lastbuyprice_withTax);
        $sqlQuery->setNumber((float) $product->meanbuyprice_withTax);
        $sqlQuery->setNumber((float) $product->price4);
        $sqlQuery->setNumber((float) $product->price5);
        $sqlQuery->setNumber((float) $product->price6);
        $sqlQuery->setNumber((float) $product->price7);
        $sqlQuery->setNumber((float) $product->price8);
        $sqlQuery->setNumber((int) $product->clientid);


        $sqlQuery->setNumber($product->productId);
        return $this->executeUpdate($sqlQuery);
    }

    //azmy
    public function update1($product, $x, $username)
    {

        $col = logo . $x;
        $sql = "UPDATE product SET  logo$x = ?, updatebyuser = ?  WHERE productId = ?";
        $sqlQuery = new SqlQuery($sql);
        //        $sqlQuery->set($product->logo);
        $sqlQuery->set($product->$col);
        $sqlQuery->set($username);

        $sqlQuery->setNumber($product->productId);
        //        var_dump($sqlQuery);
        return $this->executeUpdate($sqlQuery);
    }

    //azmy

    /**
     * Delete all rows
     */
    public function clean()
    {
        $sql = 'DELETE FROM product';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByProductName($value)
    {
        $sql = 'SELECT * FROM product WHERE productName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductDescription($value)
    {
        $sql = 'SELECT * FROM product WHERE productDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductCatId($value)
    {
        $sql = 'SELECT * FROM product WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductBuyPrice($value)
    {
        $sql = 'SELECT * FROM product WHERE productBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellAllPrice($value)
    {
        $sql = 'SELECT * FROM product WHERE productSellAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellUnitPrice($value)
    {
        $sql = 'SELECT * FROM product WHERE productSellUnitPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductSellHalfPrice($value)
    {
        $sql = 'SELECT * FROM product WHERE productSellHalfPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductDate($value)
    {
        $sql = 'SELECT * FROM product WHERE productDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value)
    {
        $sql = 'SELECT * FROM product WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value)
    {
        $sql = 'SELECT * FROM product WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByLimitamount($value)
    {
        $sql = 'SELECT * FROM product WHERE limitamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByParcode($value)
    {
        $sql = 'SELECT * FROM product WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByProductName($value)
    {
        $sql = 'DELETE FROM product WHERE productName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductDescription($value)
    {
        $sql = 'DELETE FROM product WHERE productDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductCatId($value)
    {
        $sql = 'DELETE FROM product WHERE productCatId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductBuyPrice($value)
    {
        $sql = 'DELETE FROM product WHERE productBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellAllPrice($value)
    {
        $sql = 'DELETE FROM product WHERE productSellAllPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellUnitPrice($value)
    {
        $sql = 'DELETE FROM product WHERE productSellUnitPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductSellHalfPrice($value)
    {
        $sql = 'DELETE FROM product WHERE productSellHalfPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductDate($value)
    {
        $sql = 'DELETE FROM product WHERE productDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value)
    {
        $sql = 'DELETE FROM product WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value)
    {
        $sql = 'DELETE FROM product WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByLimitamount($value)
    {
        $sql = 'DELETE FROM product WHERE limitamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByParcode($value)
    {
        $sql = 'DELETE FROM product WHERE parcode = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ProductMySql
     */
    protected function readRow($row)
    {
        $product = new Product();

        $product->productId = isset($row['productId']) ? $row['productId'] : '';
        $product->productName = isset($row['productName']) ? $row['productName'] : '';
        $product->productDescription = isset($row['productDescription']) ? $row['productDescription'] : '';
        $product->productCatId = isset($row['productCatId']) ? $row['productCatId'] : '';
        $product->productBuyPrice = isset($row['productBuyPrice']) ? $row['productBuyPrice'] : '';
        $product->productSellAllPrice = isset($row['productSellAllPrice']) ? $row['productSellAllPrice'] : '';
        $product->productSellUnitPrice = isset($row['productSellUnitPrice']) ? $row['productSellUnitPrice'] : '';
        $product->productSellHalfPrice = isset($row['productSellHalfPrice']) ? $row['productSellHalfPrice'] : '';
        $product->productDate = isset($row['productDate']) ? $row['productDate'] : '';
        $product->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $product->userId = isset($row['userId']) ? $row['userId'] : '';
        $product->limitamount = isset($row['limitamount']) ? $row['limitamount'] : '';
        $product->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $product->type = isset($row['type']) ? $row['type'] : '';
        $product->expireDate = isset($row['expireDate']) ? $row['expireDate'] : '';
        $product->obygyDetectionId = isset($row['obygyDetectionId']) ? $row['obygyDetectionId'] : '';

        //required
        $product->productquantity = isset($row['productquantity']) ? $row['productquantity'] : '';
        $product->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $product->catParentName = isset($row['catParentName']) ? $row['catParentName'] : '';

        $product->selldiscount = isset($row['selldiscount']) ? $row['selldiscount'] : '';
        $product->buydiscount = isset($row['buydiscount']) ? $row['buydiscount'] : '';
        $product->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $product->serialnumber = isset($row['serialnumber']) ? $row['serialnumber'] : '';
        $product->storedetailid = isset($row['storedetailid']) ? $row['storedetailid'] : '';
        $product->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $product->sumProductQuantity = isset($row['sumProductQuantity']) ? $row['sumProductQuantity'] : '';

        $product->productserailid = isset($row['productserailid']) ? $row['productserailid'] : '';

        $product->dailyentryId = isset($row['dailyentryId']) ? $row['dailyentryId'] : '';
        $product->isService = isset($row['isService']) ? $row['isService'] : '';
        $product->isOptic = isset($row['isOptic']) ? $row['isOptic'] : '';
        $product->lastbuyprice = isset($row['lastbuyprice']) ? $row['lastbuyprice'] : '';
        $product->lastbuyprice_withDiscount = isset($row['lastbuyprice_withDiscount']) ? $row['lastbuyprice_withDiscount'] : '';
        $product->meanbuyprice = isset($row['meanbuyprice']) ? $row['meanbuyprice'] : '';
        $product->meanbuyprice_withDiscount = isset($row['meanbuyprice_withDiscount']) ? $row['meanbuyprice_withDiscount'] : '';
        $product->lastbuyprice_withTax = isset($row['lastbuyprice_withTax']) ? $row['lastbuyprice_withTax'] : '';
        $product->meanbuyprice_withTax = isset($row['meanbuyprice_withTax']) ? $row['meanbuyprice_withTax'] : '';
        $product->productbuypricereal = isset($row['productbuypricereal']) ? $row['productbuypricereal'] : '';
        $product->buypricereal_precentage = isset($row['buypricereal_precentage']) ? $row['buypricereal_precentage'] : '';
        $product->buytotal_precentage = isset($row['buytotal_precentage']) ? $row['buytotal_precentage'] : '';
        $product->buyhalf_precentage = isset($row['buyhalf_precentage']) ? $row['buyhalf_precentage'] : '';
        $product->buypart_precentage = isset($row['buypart_precentage']) ? $row['buypart_precentage'] : '';
        $product->logo = isset($row['logo']) ? $row['logo'] : '';
        $product->inMenu = isset($row['inMenu']) ? $row['inMenu'] : '';
        $product->buypricereal = isset($row['buypricereal']) ? $row['buypricereal'] : '';
        $product->buytotal = isset($row['buytotal']) ? $row['buytotal'] : '';
        $product->buyhalf = isset($row['buyhalf']) ? $row['buyhalf'] : '';
        $product->buypart = isset($row['buypart']) ? $row['buypart'] : '';


        $product->don = isset($row['don']) ? $row['don'] : '';

        $product->namex = isset($row['namex']) ? $row['namex'] : '';


        $product->productData = isset($row['productData']) ? $row['productData'] : '';
        $product->productUnitsData = isset($row['productUnitsData']) ? $row['productUnitsData'] : '';
        $product->hasSizeAndColor = isset($row['hasSizeAndColor']) ? $row['hasSizeAndColor'] : '';
        $product->quantity = isset($row['quantity']) ? $row['quantity'] : '';

        $product->sizecolorstoredetailid = isset($row['sizecolorstoredetailid']) ? $row['sizecolorstoredetailid'] : '';
        $product->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $product->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $product->sizeName = isset($row['sizeName']) ? $row['sizeName'] : '';
        $product->colorName = isset($row['colorName']) ? $row['colorName'] : '';
        $product->catlogo = isset($row['catlogo']) ? $row['catlogo'] : '';
        $product->productCatParent = isset($row['productCatParent']) ? $row['productCatParent'] : '';
        $product->edited = isset($row['edited']) ? $row['edited'] : '';
        $product->logo1 = isset($row['logo1']) ? $row['logo1'] : '';
        $product->logo2 = isset($row['logo2']) ? $row['logo2'] : '';
        $product->logo3 = isset($row['logo3']) ? $row['logo3'] : '';
        $product->logo4 = isset($row['logo4']) ? $row['logo4'] : '';
        $product->logo5 = isset($row['logo5']) ? $row['logo5'] : '';
        $product->logo6 = isset($row['logo6']) ? $row['logo6'] : '';
        $product->logo7 = isset($row['logo7']) ? $row['logo7'] : '';
        $product->overAllAveragePrice = isset($row['overAllAveragePrice']) ? $row['overAllAveragePrice'] : '';
        $product->reviewType = isset($row['reviewType']) ? $row['reviewType'] : '';
        $product->online = isset($row['online']) ? $row['online'] : '';
        $product->updatebyuser = isset($row['updatebyuser']) ? $row['updatebyuser'] : '';
        $product->proExcelid = isset($row['proExcelid']) ? $row['proExcelid'] : '';
        $product->proExcelParcode = isset($row['proExcelParcode']) ? $row['proExcelParcode'] : '';
        $product->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $product->weightedDiscount = isset($row['weightedDiscount']) ? $row['weightedDiscount'] : '';
        $product->catExcelid = isset($row['catExcelid']) ? $row['catExcelid'] : '';
        $product->chassisNo = isset($row['chassisNo']) ? $row['chassisNo'] : '';
        $product->motorNo = isset($row['motorNo']) ? $row['motorNo'] : '';
        $product->theColor = isset($row['theColor']) ? $row['theColor'] : '';
        //
        $product->productunitid = isset($row['productunitid']) ? $row['productunitid'] : '';
        $product->unitid = isset($row['unitid']) ? $row['unitid'] : '';
        $product->proUnitSellAllPrice = isset($row['proUnitSellAllPrice']) ? $row['proUnitSellAllPrice'] : '';
        $product->proUnitSellHalfPrice = isset($row['proUnitSellHalfPrice']) ? $row['proUnitSellHalfPrice'] : '';
        $product->proUnitSellUnitPrice = isset($row['proUnitSellUnitPrice']) ? $row['proUnitSellUnitPrice'] : '';
        $product->proUnitBuyPrice = isset($row['proUnitBuyPrice']) ? $row['proUnitBuyPrice'] : '';

        //
        $product->storereportid = isset($row['storereportid']) ? $row['storereportid'] : '';
        $product->storeid = isset($row['storeid']) ? $row['storeid'] : '';
        $product->storereporttype = isset($row['storereporttype']) ? $row['storereporttype'] : '';
        $product->storereportmodelid = isset($row['storereportmodelid']) ? $row['storereportmodelid'] : '';
        $product->processname = isset($row['processname']) ? $row['processname'] : '';
        $product->tablename = isset($row['tablename']) ? $row['tablename'] : '';
        $product->productbefore = isset($row['productbefore']) ? $row['productbefore'] : '';
        $product->productafter = isset($row['productafter']) ? $row['productafter'] : '';
        $product->totalStore = isset($row['totalStore']) ? $row['totalStore'] : '';
        $product->runquery = isset($row['runquery']) ? $row['runquery'] : '';
        $product->sizeColorParcode = isset($row['sizeColorParcode']) ? $row['sizeColorParcode'] : '';
        $product->sortby = isset($row['sortby']) ? $row['sortby'] : '';
        $product->obygyInvestigationId = isset($row['obygyInvestigationId']) ? $row['obygyInvestigationId'] : '';
        $product->TypeOfBarcodeInTax = isset($row['TypeOfBarcodeInTax']) ? $row['TypeOfBarcodeInTax'] : '';
        $product->barcodeInTax = isset($row['barcodeInTax']) ? $row['barcodeInTax'] : '';
        $product->productNameE = isset($row['productNameE']) ? $row['productNameE'] : '';
        $product->partNumber = isset($row['partNumber']) ? $row['partNumber'] : '';
        $product->vehicleType = isset($row['vehicleType']) ? $row['vehicleType'] : '';
        $product->company = isset($row['company']) ? $row['company'] : '';
        $product->weight = isset($row['weight']) ? $row['weight'] : '';
        $product->origin = isset($row['origin']) ? $row['origin'] : '';
        $product->hscode = isset($row['hscode']) ? $row['hscode'] : '';
        $product->power = isset($row['power']) ? $row['power'] : '';
        $product->ProductionDate = isset($row['ProductionDate']) ? $row['ProductionDate'] : '';
        $product->expiry = isset($row['expiry']) ? $row['expiry'] : '';
        $product->procode = isset($row['procode']) ? $row['procode'] : '';
        $product->treeId = isset($row['treeId']) ? $row['treeId'] : '';
        $product->price4 = isset($row['price4']) ? $row['price4'] : '';
        $product->price5 = isset($row['price5']) ? $row['price5'] : '';
        $product->price6 = isset($row['price6']) ? $row['price6'] : '';
        $product->price7 = isset($row['price7']) ? $row['price7'] : '';
        $product->price8 = isset($row['price8']) ? $row['price8'] : '';
        $product->clientid = isset($row['clientid']) ? $row['clientid'] : '';


        return $product;
    }

    protected function getList($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ProductMySql
     */
    protected function getRow($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery)
    {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery, $multiQuery = 0)
    {
        return QueryExecutor::executeUpdate($sqlQuery, $multiQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery)
    {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery)
    {
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
