<?php

/**
 * Class that operate on table 'movementmanagedeleted'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-07-08 15:56
 */
class MovementmanagedeletedMySqlDAO implements MovementmanagedeletedDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MovementmanagedeletedMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM movementmanagedeleted WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM movementmanagedeleted';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM movementmanagedeleted ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param movementmanagedeleted primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM movementmanagedeleted WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MovementmanagedeletedMySql movementmanagedeleted
     */
    public function insert($movementmanagedeleted) {
        $sql = 'INSERT INTO movementmanagedeleted (operationname, movementmanagedate, userid, currentDo, ip, mac, deviceType) VALUES (?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($movementmanagedeleted->operationname);
        $sqlQuery->set($movementmanagedeleted->movementmanagedate);
        $sqlQuery->setNumber($movementmanagedeleted->userid);
        $sqlQuery->set($movementmanagedeleted->currentDo);
        $sqlQuery->set($movementmanagedeleted->ip);
        $sqlQuery->set($movementmanagedeleted->mac);
        $sqlQuery->set($movementmanagedeleted->deviceType);

        $id = $this->executeInsert($sqlQuery);
        $movementmanagedeleted->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MovementmanagedeletedMySql movementmanagedeleted
     */
    public function update($movementmanagedeleted) {
        $sql = 'UPDATE movementmanagedeleted SET operationname = ?, movementmanagedate = ?, userid = ?, currentDo = ?, ip = ?, mac = ?, deviceType = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($movementmanagedeleted->operationname);
        $sqlQuery->set($movementmanagedeleted->movementmanagedate);
        $sqlQuery->setNumber($movementmanagedeleted->userid);
        $sqlQuery->set($movementmanagedeleted->currentDo);
        $sqlQuery->set($movementmanagedeleted->ip);
        $sqlQuery->set($movementmanagedeleted->mac);
        $sqlQuery->set($movementmanagedeleted->deviceType);

        $sqlQuery->setNumber($movementmanagedeleted->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM movementmanagedeleted';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOperationname($value) {
        $sql = 'SELECT * FROM movementmanagedeleted WHERE operationname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByMovementmanagedate($value) {
        $sql = 'SELECT * FROM movementmanagedeleted WHERE movementmanagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM movementmanagedeleted WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCurrentDo($value) {
        $sql = 'SELECT * FROM movementmanagedeleted WHERE currentDo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOperationname($value) {
        $sql = 'DELETE FROM movementmanagedeleted WHERE operationname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByMovementmanagedate($value) {
        $sql = 'DELETE FROM movementmanagedeleted WHERE movementmanagedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM movementmanagedeleted WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCurrentDo($value) {
        $sql = 'DELETE FROM movementmanagedeleted WHERE currentDo = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MovementmanagedeletedMySql
     */
    protected function readRow($row) {
        $movementmanagedeleted = new Movementmanagedeleted();

        $movementmanagedeleted->id = $row['id'];
        $movementmanagedeleted->operationname = $row['operationname'];
        $movementmanagedeleted->movementmanagedate = $row['movementmanagedate'];
        $movementmanagedeleted->userid = $row['userid'];
        $movementmanagedeleted->currentDo = $row['currentDo'];
        $movementmanagedeleted->ip = $row['ip'];
        $movementmanagedeleted->mac = $row['mac'];
        $movementmanagedeleted->deviceType = $row['deviceType'];

        return $movementmanagedeleted;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MovementmanagedeletedMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>