<?php

/**
 * Class that operate on table 'm_handedreport'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MHandedreportMySqlDAO implements MHandedreportDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MHandedreportMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_handedreport WHERE handedReportId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_handedreport';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_handedreport ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mHandedreport primary key
     */
    public function delete($handedReportId) {
        $sql = 'DELETE FROM m_handedreport WHERE handedReportId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($handedReportId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MHandedreportMySql mHandedreport
     */
    public function insert($mHandedreport) {
        $sql = 'INSERT INTO m_handedreport (stageId, ourSerial, actualCost, initiateCost, clientCost, comment, userId, handedReportDate, archive, branchId, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mHandedreport->stageId);
        $sqlQuery->set($mHandedreport->ourSerial);
        $sqlQuery->set($mHandedreport->actualCost);
        $sqlQuery->set($mHandedreport->initiateCost);
        $sqlQuery->set($mHandedreport->clientCost);
        $sqlQuery->setString2($mHandedreport->comment);
        $sqlQuery->setNumber($mHandedreport->userId);
        $sqlQuery->set($mHandedreport->handedReportDate);
        $sqlQuery->setNumber($mHandedreport->archive);
        $sqlQuery->setNumber($mHandedreport->branchId);
        $sqlQuery->setNumber($mHandedreport->del);

        $id = $this->executeInsert($sqlQuery);
        $mHandedreport->handedReportId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MHandedreportMySql mHandedreport
     */
    public function update($mHandedreport) {
        $sql = 'UPDATE m_handedreport SET stageId = ?, ourSerial = ?, actualCost = ?, initiateCost = ?, clientCost = ?, comment = ?, userId = ?, handedReportDate = ?, archive = ?, branchId = ?, del = ? WHERE handedReportId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($mHandedreport->stageId);
        $sqlQuery->set($mHandedreport->ourSerial);
        $sqlQuery->set($mHandedreport->actualCost);
        $sqlQuery->set($mHandedreport->initiateCost);
        $sqlQuery->set($mHandedreport->clientCost);
        $sqlQuery->setString2($mHandedreport->comment);
        $sqlQuery->setNumber($mHandedreport->userId);
        $sqlQuery->set($mHandedreport->handedReportDate);
        $sqlQuery->setNumber($mHandedreport->archive);
        $sqlQuery->setNumber($mHandedreport->branchId);
        $sqlQuery->setNumber($mHandedreport->del);

        $sqlQuery->setNumber($mHandedreport->handedReportId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_handedreport';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStageId($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByActualCost($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE actualCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInitiateCost($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE initiateCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientCost($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE clientCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByHandedReportDate($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE handedReportDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByArchive($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE archive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_handedreport WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStageId($value) {
        $sql = 'DELETE FROM m_handedreport WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_handedreport WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByActualCost($value) {
        $sql = 'DELETE FROM m_handedreport WHERE actualCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInitiateCost($value) {
        $sql = 'DELETE FROM m_handedreport WHERE initiateCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientCost($value) {
        $sql = 'DELETE FROM m_handedreport WHERE clientCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_handedreport WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_handedreport WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByHandedReportDate($value) {
        $sql = 'DELETE FROM m_handedreport WHERE handedReportDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByArchive($value) {
        $sql = 'DELETE FROM m_handedreport WHERE archive = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_handedreport WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_handedreport WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MHandedreportMySql
     */
    protected function readRow($row) {
        $mHandedreport = new MHandedreport();

        $mHandedreport->handedReportId = isset($row['handedReportId']) ? $row['handedReportId'] : '';
        $mHandedreport->stageId = isset($row['stageId']) ? $row['stageId'] : '';
        $mHandedreport->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mHandedreport->actualCost = isset($row['actualCost']) ? $row['actualCost'] : '';
        $mHandedreport->initiateCost = isset($row['initiateCost']) ? $row['initiateCost'] : '';
        $mHandedreport->clientCost = isset($row['clientCost']) ? $row['clientCost'] : '';
        $mHandedreport->comment = isset($row['comment']) ? $row['comment'] : '';
        $mHandedreport->userId = isset($row['userId']) ? $row['userId'] : '';
        $mHandedreport->handedReportDate = isset($row['handedReportDate']) ? $row['handedReportDate'] : '';
        $mHandedreport->archive = isset($row['archive']) ? $row['archive'] : '';
        $mHandedreport->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mHandedreport->del = isset($row['del']) ? $row['del'] : '';

        return $mHandedreport;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MHandedreportMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>