<?php

/**
 * Class that operate on table 'm_externalmaintenance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-07 16:06
 */
class MExternalmaintenanceMySqlDAO implements MExternalmaintenanceDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return MExternalmaintenanceMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE externalmaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM m_externalmaintenance';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM m_externalmaintenance ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param mExternalmaintenance primary key
     */
    public function delete($externalmaintenanceId) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE externalmaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($externalmaintenanceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param MExternalmaintenanceMySql mExternalmaintenance
     */
    public function insert($mExternalmaintenance) {
        $sql = 'INSERT INTO m_externalmaintenance (ourSerial, supplierId, externalmaintenanceDate, comment, externalmaintenanceReturn, returnComment, supplierCost, returnedDate, branchId, userId, del) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mExternalmaintenance->ourSerial);
        $sqlQuery->setNumber($mExternalmaintenance->supplierId);
        $sqlQuery->set($mExternalmaintenance->externalmaintenanceDate);
        $sqlQuery->setString2($mExternalmaintenance->comment);
        $sqlQuery->setNumber($mExternalmaintenance->externalmaintenanceReturn);
        $sqlQuery->setString2($mExternalmaintenance->returnComment);
        $sqlQuery->set($mExternalmaintenance->supplierCost);
        $sqlQuery->set($mExternalmaintenance->returnedDate);
        $sqlQuery->setNumber($mExternalmaintenance->branchId);
        $sqlQuery->setNumber($mExternalmaintenance->userId);
        $sqlQuery->setNumber($mExternalmaintenance->del);

        $id = $this->executeInsert($sqlQuery);
        $mExternalmaintenance->externalmaintenanceId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param MExternalmaintenanceMySql mExternalmaintenance
     */
    public function update($mExternalmaintenance) {
        $sql = 'UPDATE m_externalmaintenance SET ourSerial = ?, supplierId = ?, externalmaintenanceDate = ?, comment = ?, externalmaintenanceReturn = ?, returnComment = ?, supplierCost = ?, returnedDate = ?, branchId = ?, userId = ?, del = ? WHERE externalmaintenanceId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($mExternalmaintenance->ourSerial);
        $sqlQuery->setNumber($mExternalmaintenance->supplierId);
        $sqlQuery->set($mExternalmaintenance->externalmaintenanceDate);
        $sqlQuery->setString2($mExternalmaintenance->comment);
        $sqlQuery->setNumber($mExternalmaintenance->externalmaintenanceReturn);
        $sqlQuery->setString2($mExternalmaintenance->returnComment);
        $sqlQuery->set($mExternalmaintenance->supplierCost);
        $sqlQuery->set($mExternalmaintenance->returnedDate);
        $sqlQuery->setNumber($mExternalmaintenance->branchId);
        $sqlQuery->setNumber($mExternalmaintenance->userId);
        $sqlQuery->setNumber($mExternalmaintenance->del);

        $sqlQuery->setNumber($mExternalmaintenance->externalmaintenanceId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM m_externalmaintenance';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByOurSerial($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierId($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE supplierId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExternalmaintenanceDate($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE externalmaintenanceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExternalmaintenanceReturn($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE externalmaintenanceReturn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnComment($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE returnComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierCost($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE supplierCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnedDate($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE returnedDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBranchId($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM m_externalmaintenance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByOurSerial($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE ourSerial = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierId($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE supplierId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExternalmaintenanceDate($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE externalmaintenanceDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExternalmaintenanceReturn($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE externalmaintenanceReturn = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnComment($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE returnComment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierCost($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE supplierCost = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnedDate($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE returnedDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBranchId($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE branchId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM m_externalmaintenance WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return MExternalmaintenanceMySql
     */
    protected function readRow($row) {
        $mExternalmaintenance = new MExternalmaintenance();

        $mExternalmaintenance->externalmaintenanceId = isset($row['externalmaintenanceId']) ? $row['externalmaintenanceId'] : '';
        $mExternalmaintenance->ourSerial = isset($row['ourSerial']) ? $row['ourSerial'] : '';
        $mExternalmaintenance->supplierId = isset($row['supplierId']) ? $row['supplierId'] : '';
        $mExternalmaintenance->externalmaintenanceDate = isset($row['externalmaintenanceDate']) ? $row['externalmaintenanceDate'] : '';
        $mExternalmaintenance->comment = isset($row['comment']) ? $row['comment'] : '';
        $mExternalmaintenance->externalmaintenanceReturn = isset($row['externalmaintenanceReturn']) ? $row['externalmaintenanceReturn'] : '';
        $mExternalmaintenance->returnComment = isset($row['returnComment']) ? $row['returnComment'] : '';
        $mExternalmaintenance->supplierCost = isset($row['supplierCost']) ? $row['supplierCost'] : '';
        $mExternalmaintenance->returnedDate = isset($row['returnedDate']) ? $row['returnedDate'] : '';
        $mExternalmaintenance->branchId = isset($row['branchId']) ? $row['branchId'] : '';
        $mExternalmaintenance->userId = isset($row['userId']) ? $row['userId'] : '';
        $mExternalmaintenance->del = isset($row['del']) ? $row['del'] : '';
        //req
        $mExternalmaintenance->InitialMaintenanceCost = isset($row['InitialMaintenanceCost']) ? $row['InitialMaintenanceCost'] : '';
        $mExternalmaintenance->InitialMaintenanceClientCost = isset($row['InitialMaintenanceClientCost']) ? $row['InitialMaintenanceClientCost'] : '';
        $mExternalmaintenance->ExternalMaintenanceCost = isset($row['ExternalMaintenanceCost']) ? $row['ExternalMaintenanceCost'] : '';
        $mExternalmaintenance->shipCostGo = isset($row['shipCostGo']) ? $row['shipCostGo'] : '';
        $mExternalmaintenance->shipCostReturned = isset($row['shipCostReturned']) ? $row['shipCostReturned'] : '';
        $mExternalmaintenance->insuranceCostReplace = isset($row['insuranceCostReplace']) ? $row['insuranceCostReplace'] : '';
        $mExternalmaintenance->insuranceCostDiscount = isset($row['insuranceCostDiscount']) ? $row['insuranceCostDiscount'] : '';
        $mExternalmaintenance->itemDiscount = isset($row['itemDiscount']) ? $row['itemDiscount'] : '';
        $mExternalmaintenance->insuranceCostMaintenance = isset($row['insuranceCostMaintenance']) ? $row['insuranceCostMaintenance'] : '';
        $mExternalmaintenance->totalOfTotals = isset($row['totalOfTotals']) ? $row['totalOfTotals'] : '';
        $mExternalmaintenance->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $mExternalmaintenance->receiptid = isset($row['receiptid']) ? $row['receiptid'] : '';
        $mExternalmaintenance->productName = isset($row['productName']) ? $row['productName'] : '';
        $mExternalmaintenance->productserial = isset($row['productserial']) ? $row['productserial'] : '';

        return $mExternalmaintenance;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return MExternalmaintenanceMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>