<?php

/**
 * Class that operate on table 'employeedoctordebtchange'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
class EmployeedoctordebtchangeMySqlDAO implements EmployeedoctordebtchangeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeedoctordebtchangeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeedoctordebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeedoctordebtchange ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeedoctordebtchange primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeedoctordebtchangeMySql employeedoctordebtchange
     */
    public function insert($employeedoctordebtchange) {
        $sql = 'INSERT INTO employeedoctordebtchange (employeeOrDoctor, employeeOrDoctorId, debtchangebefore, debtchangeamount, debtchangetype, processname, debtchangemodelid, debtchangeafter, debtchangedate, userid, tablename, comment, del, dailyentryid, saveid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctordebtchange->employeeOrDoctor);
        $sqlQuery->setNumber($employeedoctordebtchange->employeeOrDoctorId);
        $sqlQuery->set($employeedoctordebtchange->debtchangebefore);
        $sqlQuery->set($employeedoctordebtchange->debtchangeamount);
        $sqlQuery->setNumber($employeedoctordebtchange->debtchangetype);
        $sqlQuery->set($employeedoctordebtchange->processname);
        $sqlQuery->setNumber($employeedoctordebtchange->debtchangemodelid);
        $sqlQuery->set($employeedoctordebtchange->debtchangeafter);
        $sqlQuery->set($employeedoctordebtchange->debtchangedate);
        $sqlQuery->setNumber($employeedoctordebtchange->userid);
        $sqlQuery->set($employeedoctordebtchange->tablename);
        $sqlQuery->setString2($employeedoctordebtchange->comment);
        $sqlQuery->setNumber($employeedoctordebtchange->del);
        $sqlQuery->setNumber((int) $employeedoctordebtchange->dailyentryid);
        $sqlQuery->setNumber($employeedoctordebtchange->saveid);

        $id = $this->executeInsert($sqlQuery);
        $employeedoctordebtchange->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeedoctordebtchangeMySql employeedoctordebtchange
     */
    public function update($employeedoctordebtchange) {
        $sql = 'UPDATE employeedoctordebtchange SET employeeOrDoctor = ?, employeeOrDoctorId = ?, debtchangebefore = ?, debtchangeamount = ?, debtchangetype = ?, processname = ?, debtchangemodelid = ?, debtchangeafter = ?, debtchangedate = ?, userid = ?, tablename = ?, comment = ?, del = ?, dailyentryid = ?, saveid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeedoctordebtchange->employeeOrDoctor);
        $sqlQuery->setNumber($employeedoctordebtchange->employeeOrDoctorId);
        $sqlQuery->set($employeedoctordebtchange->debtchangebefore);
        $sqlQuery->set($employeedoctordebtchange->debtchangeamount);
        $sqlQuery->setNumber($employeedoctordebtchange->debtchangetype);
        $sqlQuery->set($employeedoctordebtchange->processname);
        $sqlQuery->setNumber($employeedoctordebtchange->debtchangemodelid);
        $sqlQuery->set($employeedoctordebtchange->debtchangeafter);
        $sqlQuery->set($employeedoctordebtchange->debtchangedate);
        $sqlQuery->setNumber($employeedoctordebtchange->userid);
        $sqlQuery->set($employeedoctordebtchange->tablename);
        $sqlQuery->setString2($employeedoctordebtchange->comment);
        $sqlQuery->setNumber($employeedoctordebtchange->del);
        $sqlQuery->setNumber((int) $employeedoctordebtchange->dailyentryid);
        $sqlQuery->setNumber($employeedoctordebtchange->saveid);

        $sqlQuery->setNumber($employeedoctordebtchange->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeedoctordebtchange';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmployeeOrDoctor($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE employeeOrDoctor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeOrDoctorId($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE employeeOrDoctorId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangebefore($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangeamount($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangetype($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProcessname($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangemodelid($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangeafter($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDebtchangedate($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE debtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTablename($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDel($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDailyentryid($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySaveid($value) {
        $sql = 'SELECT * FROM employeedoctordebtchange WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmployeeOrDoctor($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE employeeOrDoctor = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeOrDoctorId($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE employeeOrDoctorId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangebefore($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangebefore = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangeamount($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangeamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangetype($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangetype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProcessname($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE processname = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangemodelid($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangemodelid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangeafter($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangeafter = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDebtchangedate($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE debtchangedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTablename($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE tablename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDel($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE del = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDailyentryid($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE dailyentryid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySaveid($value) {
        $sql = 'DELETE FROM employeedoctordebtchange WHERE saveid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeedoctordebtchangeMySql
     */
    protected function readRow($row) {
        $employeedoctordebtchange = new Employeedoctordebtchange();

        $employeedoctordebtchange->id = $row['id'];
        $employeedoctordebtchange->employeeOrDoctor = $row['employeeOrDoctor'];
        $employeedoctordebtchange->employeeOrDoctorId = $row['employeeOrDoctorId'];
        $employeedoctordebtchange->debtchangebefore = $row['debtchangebefore'];
        $employeedoctordebtchange->debtchangeamount = $row['debtchangeamount'];
        $employeedoctordebtchange->debtchangetype = $row['debtchangetype'];
        $employeedoctordebtchange->processname = $row['processname'];
        $employeedoctordebtchange->debtchangemodelid = $row['debtchangemodelid'];
        $employeedoctordebtchange->debtchangeafter = $row['debtchangeafter'];
        $employeedoctordebtchange->debtchangedate = $row['debtchangedate'];
        $employeedoctordebtchange->userid = $row['userid'];
        $employeedoctordebtchange->tablename = $row['tablename'];
        $employeedoctordebtchange->comment = $row['comment'];
        $employeedoctordebtchange->del = $row['del'];
        $employeedoctordebtchange->dailyentryid = $row['dailyentryid'];
        $employeedoctordebtchange->saveid = $row['saveid'];

        return $employeedoctordebtchange;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeedoctordebtchangeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>