<?php

/**
 * Class that operate on table 'bills'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
class BillsMySqlDAO implements BillsDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return BillsMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM bills WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM bills';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM bills ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param bill primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM bills WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param BillsMySql bill
     */
    public function insert($bill) {
        $sql = 'INSERT INTO bills (clientid, receivedate, billno, comment, billdate, kashfid, cash, cashvalue, waitvalue, insurance, insurancecompanyid, customerpercent, customermax, customercarry, companyaccept, companycarry, card, cardvalue, paymentnetworkid, userid, deleted, kashftype, alloweddays, productstotalprice, kashfvalue, kashfdiscount, netbillvalue, discounttype, discountvalue, finalnetbillvalue, offline, uploaddate , pricetype,billstatus , approvalno , kashfdate ,kashfplace ,deliverytime,dailyentryid ,insdiscountpercent ,clientPayReceiptVal,netdiscountpercent,branchid , serverdate , rondomtxt, attatch,approved,saveid,approveNo,approveFile,notifSeen,payType) VALUES (?,?,?,? ,?, ? , ? , ? , ? , ? ,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bill->clientid);
        $sqlQuery->set($bill->receivedate);
        $sqlQuery->set($bill->billno);
        $sqlQuery->setString2($bill->comment);
        $sqlQuery->set($bill->billdate);
        $sqlQuery->setNumber($bill->kashfid);
        $sqlQuery->setNumber($bill->cash);
        $sqlQuery->set($bill->cashvalue);
        $sqlQuery->set($bill->waitvalue);
        $sqlQuery->setNumber($bill->insurance);
        $sqlQuery->setNumber($bill->insurancecompanyid);
        $sqlQuery->set($bill->customerpercent);
        $sqlQuery->set($bill->customermax);
        $sqlQuery->set($bill->customercarry);
        $sqlQuery->set($bill->companyaccept);
        $sqlQuery->set($bill->companycarry);
        $sqlQuery->setNumber($bill->card);
        $sqlQuery->set($bill->cardvalue);
        $sqlQuery->setNumber($bill->paymentnetworkid);
        $sqlQuery->setNumber($bill->userid);
        $sqlQuery->setNumber($bill->deleted);
        $sqlQuery->setNumber($bill->kashftype);
        $sqlQuery->setNumber($bill->alloweddays);
        $sqlQuery->set($bill->productstotalprice);
        $sqlQuery->set($bill->kashfvalue);
        $sqlQuery->set($bill->kashfdiscount);
        $sqlQuery->set($bill->netbillvalue);
        $sqlQuery->setNumber($bill->discounttype);
        $sqlQuery->set($bill->discountvalue);
        $sqlQuery->set($bill->finalnetbillvalue);
        $sqlQuery->setNumber($bill->offline);
        $sqlQuery->set($bill->uploaddate);
        $sqlQuery->setNumber($bill->pricetype);
        $sqlQuery->setNumber($bill->billstatus);
        $sqlQuery->set($bill->approvalno);

        $sqlQuery->set($bill->kashfdate);
        $sqlQuery->set($bill->kashfplace);
        $sqlQuery->set($bill->deliverytime);

        $sqlQuery->set($bill->dailyentryid);
        $sqlQuery->set($bill->insdiscountpercent);
        $sqlQuery->setNumber($bill->clientPayReceiptVal);
        $sqlQuery->set($bill->netdiscountpercent);
        $sqlQuery->setNumber($bill->branchid);
        $sqlQuery->set($bill->serverdate);
        $sqlQuery->set($bill->rondomtxt);
        $sqlQuery->set($bill->attatch);
        $sqlQuery->setNumber($bill->approved);

        $sqlQuery->setNumber($bill->saveid);
        $sqlQuery->set($bill->approveNo);
        $sqlQuery->set($bill->approveFile);
        $sqlQuery->setNumber($bill->notifSeen);
        $sqlQuery->set($bill->payType);

        $id = $this->executeInsert($sqlQuery);
        $bill->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param BillsMySql bill
     */
    public function update($bill) {
        $sql = 'UPDATE bills SET clientid = ?, receivedate = ?, billno = ?, comment = ?, billdate = ?, kashfid = ?, cash = ?, cashvalue = ?, waitvalue = ?, insurance = ?, insurancecompanyid = ?, customerpercent = ?, customermax = ?, customercarry = ?, companyaccept = ?, companycarry = ?, card = ?, cardvalue = ?, paymentnetworkid = ?, userid = ?, deleted = ?, kashftype = ?, alloweddays = ?, productstotalprice = ?, kashfvalue = ?, kashfdiscount = ?, netbillvalue = ?, discounttype = ?, discountvalue = ?, finalnetbillvalue = ?, offline = ?, uploaddate = ? , pricetype = ? , approvalno = ? , kashfdate = ? , kashfplace = ? , deliverytime = ? ,dailyentryid = ?  ,insdiscountpercent = ?,clientPayReceiptVal = ? ,netdiscountpercent = ? ,branchid = ? ,serverdate = ? , rondomtxt = ?,attatch = ?,approved = ?,saveid = ?,approveNo = ?,approveFile = ?,notifSeen = ?,payType = ?  WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($bill->clientid);
        $sqlQuery->set($bill->receivedate);
        $sqlQuery->set($bill->billno);
        $sqlQuery->setString2($bill->comment);
        $sqlQuery->set($bill->billdate);
        $sqlQuery->setNumber($bill->kashfid);
        $sqlQuery->setNumber($bill->cash);
        $sqlQuery->set($bill->cashvalue);
        $sqlQuery->set($bill->waitvalue);
        $sqlQuery->setNumber($bill->insurance);
        $sqlQuery->setNumber($bill->insurancecompanyid);
        $sqlQuery->set($bill->customerpercent);
        $sqlQuery->set($bill->customermax);
        $sqlQuery->set($bill->customercarry);
        $sqlQuery->set($bill->companyaccept);
        $sqlQuery->set($bill->companycarry);
        $sqlQuery->setNumber($bill->card);
        $sqlQuery->set($bill->cardvalue);
        $sqlQuery->setNumber($bill->paymentnetworkid);
        $sqlQuery->setNumber($bill->userid);
        $sqlQuery->setNumber($bill->deleted);
        $sqlQuery->setNumber($bill->kashftype);
        $sqlQuery->setNumber($bill->alloweddays);
        $sqlQuery->set($bill->productstotalprice);
        $sqlQuery->set($bill->kashfvalue);
        $sqlQuery->set($bill->kashfdiscount);
        $sqlQuery->set($bill->netbillvalue);
        $sqlQuery->setNumber($bill->discounttype);
        $sqlQuery->set($bill->discountvalue);
        $sqlQuery->set($bill->finalnetbillvalue);
        $sqlQuery->setNumber($bill->offline);
        $sqlQuery->set($bill->uploaddate);
        $sqlQuery->setNumber($bill->pricetype);
        $sqlQuery->set($bill->approvalno);

        $sqlQuery->set($bill->kashfdate);
        $sqlQuery->set($bill->kashfplace);
        $sqlQuery->set($bill->deliverytime);

        $sqlQuery->set($bill->dailyentryid);
        $sqlQuery->set($bill->insdiscountpercent);
        $sqlQuery->setNumber($bill->clientPayReceiptVal);
        $sqlQuery->set($bill->netdiscountpercent);
        $sqlQuery->setNumber($bill->branchid);
        $sqlQuery->set($bill->serverdate);
        $sqlQuery->set($bill->rondomtxt);
        $sqlQuery->set($bill->attatch);
        $sqlQuery->setNumber($bill->approved);

        $sqlQuery->setNumber($bill->saveid);
        $sqlQuery->set($bill->approveNo);
        $sqlQuery->set($bill->approveFile);
        $sqlQuery->setNumber($bill->notifSeen);
        $sqlQuery->set($bill->payType);

        $sqlQuery->setNumber($bill->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM bills';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientid($value) {
        $sql = 'SELECT * FROM bills WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReceivedate($value) {
        $sql = 'SELECT * FROM bills WHERE receivedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBillno($value) {
        $sql = 'SELECT * FROM bills WHERE billno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM bills WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByBilldate($value) {
        $sql = 'SELECT * FROM bills WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfid($value) {
        $sql = 'SELECT * FROM bills WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCash($value) {
        $sql = 'SELECT * FROM bills WHERE cash = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCashvalue($value) {
        $sql = 'SELECT * FROM bills WHERE cashvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWaitvalue($value) {
        $sql = 'SELECT * FROM bills WHERE waitvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsurance($value) {
        $sql = 'SELECT * FROM bills WHERE insurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByInsurancecompanyid($value) {
        $sql = 'SELECT * FROM bills WHERE insurancecompanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomerpercent($value) {
        $sql = 'SELECT * FROM bills WHERE customerpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomermax($value) {
        $sql = 'SELECT * FROM bills WHERE customermax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCustomercarry($value) {
        $sql = 'SELECT * FROM bills WHERE customercarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanyaccept($value) {
        $sql = 'SELECT * FROM bills WHERE companyaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCompanycarry($value) {
        $sql = 'SELECT * FROM bills WHERE companycarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCard($value) {
        $sql = 'SELECT * FROM bills WHERE card = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByCardvalue($value) {
        $sql = 'SELECT * FROM bills WHERE cardvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByPaymentnetworkid($value) {
        $sql = 'SELECT * FROM bills WHERE paymentnetworkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM bills WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDeleted($value) {
        $sql = 'SELECT * FROM bills WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashftype($value) {
        $sql = 'SELECT * FROM bills WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByAlloweddays($value) {
        $sql = 'SELECT * FROM bills WHERE alloweddays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductstotalprice($value) {
        $sql = 'SELECT * FROM bills WHERE productstotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfvalue($value) {
        $sql = 'SELECT * FROM bills WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByKashfdiscount($value) {
        $sql = 'SELECT * FROM bills WHERE kashfdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByNetbillvalue($value) {
        $sql = 'SELECT * FROM bills WHERE netbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscounttype($value) {
        $sql = 'SELECT * FROM bills WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByDiscountvalue($value) {
        $sql = 'SELECT * FROM bills WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByFinalnetbillvalue($value) {
        $sql = 'SELECT * FROM bills WHERE finalnetbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOffline($value) {
        $sql = 'SELECT * FROM bills WHERE offline = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUploaddate($value) {
        $sql = 'SELECT * FROM bills WHERE uploaddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientid($value) {
        $sql = 'DELETE FROM bills WHERE clientid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReceivedate($value) {
        $sql = 'DELETE FROM bills WHERE receivedate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBillno($value) {
        $sql = 'DELETE FROM bills WHERE billno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM bills WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByBilldate($value) {
        $sql = 'DELETE FROM bills WHERE billdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfid($value) {
        $sql = 'DELETE FROM bills WHERE kashfid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCash($value) {
        $sql = 'DELETE FROM bills WHERE cash = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCashvalue($value) {
        $sql = 'DELETE FROM bills WHERE cashvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWaitvalue($value) {
        $sql = 'DELETE FROM bills WHERE waitvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsurance($value) {
        $sql = 'DELETE FROM bills WHERE insurance = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByInsurancecompanyid($value) {
        $sql = 'DELETE FROM bills WHERE insurancecompanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomerpercent($value) {
        $sql = 'DELETE FROM bills WHERE customerpercent = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomermax($value) {
        $sql = 'DELETE FROM bills WHERE customermax = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCustomercarry($value) {
        $sql = 'DELETE FROM bills WHERE customercarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanyaccept($value) {
        $sql = 'DELETE FROM bills WHERE companyaccept = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCompanycarry($value) {
        $sql = 'DELETE FROM bills WHERE companycarry = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCard($value) {
        $sql = 'DELETE FROM bills WHERE card = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByCardvalue($value) {
        $sql = 'DELETE FROM bills WHERE cardvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByPaymentnetworkid($value) {
        $sql = 'DELETE FROM bills WHERE paymentnetworkid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM bills WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDeleted($value) {
        $sql = 'DELETE FROM bills WHERE deleted = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashftype($value) {
        $sql = 'DELETE FROM bills WHERE kashftype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByAlloweddays($value) {
        $sql = 'DELETE FROM bills WHERE alloweddays = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductstotalprice($value) {
        $sql = 'DELETE FROM bills WHERE productstotalprice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfvalue($value) {
        $sql = 'DELETE FROM bills WHERE kashfvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByKashfdiscount($value) {
        $sql = 'DELETE FROM bills WHERE kashfdiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByNetbillvalue($value) {
        $sql = 'DELETE FROM bills WHERE netbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscounttype($value) {
        $sql = 'DELETE FROM bills WHERE discounttype = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByDiscountvalue($value) {
        $sql = 'DELETE FROM bills WHERE discountvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByFinalnetbillvalue($value) {
        $sql = 'DELETE FROM bills WHERE finalnetbillvalue = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOffline($value) {
        $sql = 'DELETE FROM bills WHERE offline = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUploaddate($value) {
        $sql = 'DELETE FROM bills WHERE uploaddate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return BillsMySql
     */
    protected function readRow($row) {
        $bill = new Bill();

        $bill->id = isset($row['id']) ? $row['id'] : '';
        $bill->clientid = isset($row['clientid']) ? $row['clientid'] : '';
        $bill->receivedate = isset($row['receivedate']) ? $row['receivedate'] : '';
        $bill->billno = isset($row['billno']) ? $row['billno'] : '';
        $bill->comment = isset($row['comment']) ? $row['comment'] : '';
        $bill->billdate = isset($row['billdate']) ? $row['billdate'] : '';
        $bill->kashfid = isset($row['kashfid']) ? $row['kashfid'] : '';
        $bill->cash = isset($row['cash']) ? $row['cash'] : '';
        $bill->cashvalue = isset($row['cashvalue']) ? $row['cashvalue'] : '';
        $bill->waitvalue = isset($row['waitvalue']) ? $row['waitvalue'] : '';
        $bill->insurance = isset($row['insurance']) ? $row['insurance'] : '';
        $bill->insurancecompanyid = isset($row['insurancecompanyid']) ? $row['insurancecompanyid'] : '';
        $bill->customerpercent = isset($row['customerpercent']) ? $row['customerpercent'] : '';
        $bill->customermax = isset($row['customermax']) ? $row['customermax'] : '';
        $bill->customercarry = isset($row['customercarry']) ? $row['customercarry'] : '';
        $bill->companyaccept = isset($row['companyaccept']) ? $row['companyaccept'] : '';
        $bill->companycarry = isset($row['companycarry']) ? $row['companycarry'] : '';
        $bill->card = isset($row['card']) ? $row['card'] : '';
        $bill->cardvalue = isset($row['cardvalue']) ? $row['cardvalue'] : '';
        $bill->paymentnetworkid = isset($row['paymentnetworkid']) ? $row['paymentnetworkid'] : '';
        $bill->userid = isset($row['userid']) ? $row['userid'] : '';
        $bill->deleted = isset($row['deleted']) ? $row['deleted'] : '';
        $bill->kashftype = isset($row['kashftype']) ? $row['kashftype'] : '';
        $bill->alloweddays = isset($row['alloweddays']) ? $row['alloweddays'] : '';
        $bill->productstotalprice = isset($row['productstotalprice']) ? $row['productstotalprice'] : '';
        $bill->kashfvalue = isset($row['kashfvalue']) ? $row['kashfvalue'] : '';
        $bill->kashfdiscount = isset($row['kashfdiscount']) ? $row['kashfdiscount'] : '';
        $bill->netbillvalue = isset($row['netbillvalue']) ? $row['netbillvalue'] : '';
        $bill->discounttype = isset($row['discounttype']) ? $row['discounttype'] : '';
        $bill->discountvalue = isset($row['discountvalue']) ? $row['discountvalue'] : '';
        $bill->finalnetbillvalue = isset($row['finalnetbillvalue']) ? $row['finalnetbillvalue'] : '';
        $bill->offline = isset($row['offline']) ? $row['offline'] : '';
        $bill->uploaddate = isset($row['uploaddate']) ? $row['uploaddate'] : '';
        $bill->pricetype = isset($row['pricetype']) ? $row['pricetype'] : '';
        $bill->billstatus = isset($row['billstatus']) ? $row['billstatus'] : '';
        $bill->approvalno = isset($row['approvalno']) ? $row['approvalno'] : '';

        $bill->deliverytime = isset($row['deliverytime']) ? $row['deliverytime'] : '';
        $bill->kashfplace = isset($row['kashfplace']) ? $row['kashfplace'] : '';
        $bill->kashfdate = isset($row['kashfdate']) ? $row['kashfdate'] : '';

        $bill->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';
        $bill->insdiscountpercent = isset($row['insdiscountpercent']) ? $row['insdiscountpercent'] : '';
        $bill->clientPayReceiptVal = isset($row['clientPayReceiptVal']) ? $row['clientPayReceiptVal'] : '';
        $bill->netdiscountpercent = isset($row['netdiscountpercent']) ? $row['netdiscountpercent'] : '';
        $bill->branchid = isset($row['branchid']) ? $row['branchid'] : '';
        $bill->serverdate = isset($row['serverdate']) ? $row['serverdate'] : '';
        $bill->rondomtxt = isset($row['rondomtxt']) ? $row['billrondomtxtpropertyid'] : '';
        $bill->attatch = isset($row['attatch']) ? $row['attatch'] : '';
        $bill->approved = isset($row['approved']) ? $row['approved'] : '';

        $bill->saveid = isset($row['saveid']) ? $row['saveid'] : '';
        $bill->approveNo = isset($row['approveNo']) ? $row['approveNo'] : '';
        $bill->approveFile = isset($row['approveFile']) ? $row['approveFile'] : '';
        $bill->notifSeen = isset($row['notifSeen']) ? $row['notifSeen'] : '';
        $bill->payType = isset($row['payType']) ? $row['payType'] : '';
        #####################################
        $bill->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $bill->companyname = isset($row['companyname']) ? $row['companyname'] : '';
        $bill->networkname = isset($row['networkname']) ? $row['networkname'] : '';
        $bill->username = isset($row['username']) ? $row['username'] : '';
        $bill->sellbillfinalbill = isset($row['sellbillfinalbill']) ? $row['sellbillfinalbill'] : '';
        $bill->theDate = isset($row['theDate']) ? $row['theDate'] : '';
        $bill->clientareaid = isset($row['clientareaid']) ? $row['clientareaid'] : '';

        $bill->totalAccept = isset($row['totalAccept']) ? $row['totalAccept'] : '';
        $bill->totalCarry = isset($row['totalCarry']) ? $row['totalCarry'] : '';
        $bill->totalDiscount = isset($row['totalDiscount']) ? $row['totalDiscount'] : '';
        $bill->totalNet = isset($row['totalNet']) ? $row['totalNet'] : '';
        $bill->returnprice = isset($row['returnprice']) ? $row['returnprice'] : '';
        $bill->returnvalue = isset($row['returnvalue']) ? $row['returnvalue'] : '';
        $bill->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $bill->totaldiscount = isset($row['totaldiscount']) ? $row['totaldiscount'] : '';

        // m7md
        $bill->sumBillQuantity = isset($row['sumBillQuantity']) ? $row['sumBillQuantity'] : '';
        $bill->sumBilltotalbill = isset($row['sumBilltotalbill']) ? $row['sumBilltotalbill'] : '';
        $bill->productid = isset($row['productid']) ? $row['productid'] : '';
        $bill->productName = isset($row['productName']) ? $row['productName'] : '';
        $bill->sumBillDiscount = isset($row['sumBillDiscount']) ? $row['sumBillDiscount'] : '';
        $bill->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';



        return $bill;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return BillsMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>