<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-10-28 01:38
 */
interface TransferbtweenbankaccountDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Transferbtweenbankaccount 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param transferbtweenbankaccount primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Transferbtweenbankaccount transferbtweenbankaccount
 	 */
	public function insert($transferbtweenbankaccount);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Transferbtweenbankaccount transferbtweenbankaccount
 	 */
	public function update($transferbtweenbankaccount);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankidfrom($value);

	public function queryByAccountidfrom($value);

	public function queryByBankidto($value);

	public function queryByAccountidto($value);

	public function queryByTransfervalue($value);

	public function queryByTransferdate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByDailyentryid($value);

	public function queryByComment($value);


	public function deleteByBankidfrom($value);

	public function deleteByAccountidfrom($value);

	public function deleteByBankidto($value);

	public function deleteByAccountidto($value);

	public function deleteByTransfervalue($value);

	public function deleteByTransferdate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByDailyentryid($value);

	public function deleteByComment($value);


}
?>