<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-20 15:34
 */
interface SupplieropendebtchangeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supplieropendebtchange 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supplieropendebtchange primary key
 	 */
	public function delete($supplieropendebtchangeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supplieropendebtchange supplieropendebtchange
 	 */
	public function insert($supplieropendebtchange);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supplieropendebtchange supplieropendebtchange
 	 */
	public function update($supplieropendebtchange);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOpensupplierid($value);

	public function queryBySupplierdebtchangebefore($value);

	public function queryBySupplierdebtchangeamount($value);

	public function queryBySupplierdebtchangetype($value);

	public function queryByProcessname($value);

	public function queryBySupplierdebtchangemodelid($value);

	public function queryBySupplierdebtchangeafter($value);

	public function queryBySupplierdebtchangedate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);

	public function queryByComment($value);

	public function queryByDel($value);

	public function queryByDailyentryid($value);

	public function queryBySaveid($value);

	public function queryByCostcenterid($value);

	public function queryByCurrencyId($value);

	public function queryByConversionFactor($value);

	public function queryByPayedInCurrency($value);

	public function queryBySaveConversionFactor($value);


	public function deleteByOpensupplierid($value);

	public function deleteBySupplierdebtchangebefore($value);

	public function deleteBySupplierdebtchangeamount($value);

	public function deleteBySupplierdebtchangetype($value);

	public function deleteByProcessname($value);

	public function deleteBySupplierdebtchangemodelid($value);

	public function deleteBySupplierdebtchangeafter($value);

	public function deleteBySupplierdebtchangedate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);

	public function deleteByComment($value);

	public function deleteByDel($value);

	public function deleteByDailyentryid($value);

	public function deleteBySaveid($value);

	public function deleteByCostcenterid($value);

	public function deleteByCurrencyId($value);

	public function deleteByConversionFactor($value);

	public function deleteByPayedInCurrency($value);

	public function deleteBySaveConversionFactor($value);


}
?>