<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ReturnsellbilldetailDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnsellbilldetail 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnsellbilldetail primary key
 	 */
	public function delete($returnsellbilldetailid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnsellbilldetail returnsellbilldetail
 	 */
	public function insert($returnsellbilldetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnsellbilldetail returnsellbilldetail
 	 */
	public function update($returnsellbilldetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuyprice($value);

	public function queryByParcode($value);

	public function queryByReturnsellbillid($value);

	public function queryByReturnsellbilldetailcatid($value);

	public function queryByReturnsellbilldetailproductid($value);

	public function queryByReturnsellbilldetailquantity($value);

	public function queryByReturnsellbilldetailprice($value);

	public function queryByReturnsellbilldetailtotalprice($value);

	public function queryByCondition($value);

	public function queryByNote($value);

	public function queryByPricetype($value);

	public function queryByDiscountvalue($value);


	public function deleteByBuyprice($value);

	public function deleteByParcode($value);

	public function deleteByReturnsellbillid($value);

	public function deleteByReturnsellbilldetailcatid($value);

	public function deleteByReturnsellbilldetailproductid($value);

	public function deleteByReturnsellbilldetailquantity($value);

	public function deleteByReturnsellbilldetailprice($value);

	public function deleteByReturnsellbilldetailtotalprice($value);

	public function deleteByCondition($value);

	public function deleteByNote($value);

	public function deleteByPricetype($value);

	public function deleteByDiscountvalue($value);


}
?>