<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:38
 */
interface RestaurantorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantorder 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantorder primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantorder restaurantorder
 	 */
	public function insert($restaurantorder);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantorder restaurantorder
 	 */
	public function update($restaurantorder);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByHallUserId($value);

	public function queryByTableId($value);

	public function queryByFinished($value);

	public function queryByUserId($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByHallUserId($value);

	public function deleteByTableId($value);

	public function deleteByFinished($value);

	public function deleteByUserId($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>