<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface PurchasebillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Purchasebill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param purchasebill primary key
 	 */
	public function delete($purchasebillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Purchasebill purchasebill
 	 */
	public function insert($purchasebill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Purchasebill purchasebill
 	 */
	public function update($purchasebill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialssupplierid($value);

	public function queryByPurchasebilldate($value);

	public function queryByRawmaterialssupplierdebtbefore($value);

	public function queryByRawmaterialssupplierdebtafter($value);

	public function queryByStorerawmaterialid($value);

	public function queryByPurchasebilltotalbeforediscount($value);

	public function queryByPurchasebilldiscount($value);

	public function queryByPurchasebillpayed($value);

	public function queryByPurchasebilltotalafterdiscount($value);

	public function queryByTempdelete($value);


	public function deleteByRawmaterialssupplierid($value);

	public function deleteByPurchasebilldate($value);

	public function deleteByRawmaterialssupplierdebtbefore($value);

	public function deleteByRawmaterialssupplierdebtafter($value);

	public function deleteByStorerawmaterialid($value);

	public function deleteByPurchasebilltotalbeforediscount($value);

	public function deleteByPurchasebilldiscount($value);

	public function deleteByPurchasebillpayed($value);

	public function deleteByPurchasebilltotalafterdiscount($value);

	public function deleteByTempdelete($value);


}
?>