<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface PartnerwithdrawalDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Partnerwithdrawal 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param partnerwithdrawal primary key
 	 */
	public function delete($partnerwithdrawalid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Partnerwithdrawal partnerwithdrawal
 	 */
	public function insert($partnerwithdrawal);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Partnerwithdrawal partnerwithdrawal
 	 */
	public function update($partnerwithdrawal);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPartnerid($value);

	public function queryByPartnerwithdrawalvalue($value);

	public function queryByComment($value);

	public function queryByPartnerwithdrawaldate($value);

	public function queryByUserid($value);

	public function queryBySaveid($value);

	public function queryByConditions($value);


	public function deleteByPartnerid($value);

	public function deleteByPartnerwithdrawalvalue($value);

	public function deleteByComment($value);

	public function deleteByPartnerwithdrawaldate($value);

	public function deleteByUserid($value);

	public function deleteBySaveid($value);

	public function deleteByConditions($value);


}
?>