<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface PartnerDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Partner 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param partner primary key
 	 */
	public function delete($partnerid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Partner partner
 	 */
	public function insert($partner, $comment);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Partner partner
 	 */
	public function update($partner, $comment);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByPartnername($value);

	public function queryByPartnerdate($value);

	public function queryByPartnerpercentage($value);

	public function queryByPartnermoney($value);

	public function queryByConditions($value);

	public function queryByComment($value);

	public function queryByUserid($value);


	public function deleteByPartnername($value);

	public function deleteByPartnerdate($value);

	public function deleteByPartnerpercentage($value);

	public function deleteByPartnermoney($value);

	public function deleteByConditions($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);


}
?>