<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:17
 */
interface NoticsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Notics 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param notic primary key
 	 */
	public function delete($noticesid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Notics notic
 	 */
	public function insert($notic);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Notics notic
 	 */
	public function update($notic);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductno($value);

	public function queryByProductnotsellno($value);

	public function queryByKempilano($value);

	public function queryByClientcheckno($value);

	public function queryBySuppliercheckno($value);


	public function deleteByProductno($value);

	public function deleteByProductnotsellno($value);

	public function deleteByKempilano($value);

	public function deleteByClientcheckno($value);

	public function deleteBySuppliercheckno($value);


}
?>