<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-07-19 10:51
 */
interface IncometypeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Incometype 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param incometype primary key
 	 */
	public function delete($incomeTypeId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Incometype incometype
 	 */
	public function insert($incometype);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Incometype incometype
 	 */
	public function update($incometype);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByIncomeTypeName($value);

	public function queryByIncomeTypeDetails($value);

	public function queryByParent($value);

	public function queryByIncomeTypeDate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);


	public function deleteByIncomeTypeName($value);

	public function deleteByIncomeTypeDetails($value);

	public function deleteByParent($value);

	public function deleteByIncomeTypeDate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);


}
?>