<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-06-24 12:09
 */
interface EntryproductspurchasedDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Entryproductspurchased 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param entryproductspurchased primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Entryproductspurchased entryproductspurchased
 	 */
	public function insert($entryproductspurchased);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Entryproductspurchased entryproductspurchased
 	 */
	public function update($entryproductspurchased);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByPrice($value);

	public function queryByProductquantity($value);

	public function queryBySoldquantity($value);

	public function queryByTablename($value);

	public function queryByModelid($value);

	public function queryByExpirationDate($value);

	public function queryByPriority($value);

	public function queryByDel($value);


	public function deleteByProductid($value);

	public function deleteByPrice($value);

	public function deleteByProductquantity($value);

	public function deleteBySoldquantity($value);

	public function deleteByTablename($value);

	public function deleteByModelid($value);

	public function deleteByExpirationDate($value);

	public function deleteByPriority($value);

	public function deleteByDel($value);


}
?>