<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface CheckwithdrawalDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Checkwithdrawal 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param checkwithdrawal primary key
 	 */
	public function delete($checkwithdrawalid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Checkwithdrawal checkwithdrawal
 	 */
	public function insert($checkwithdrawal,$checkwithdrawalnote);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Checkwithdrawal checkwithdrawal
 	 */
	public function update($checkwithdrawal);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankaccountid($value);

	public function queryBySupplierid($value);

	public function queryByAccountbeforevalue($value);

	public function queryByCheckwithdrawaluser($value);

	public function queryByCheckwithdrawalamount($value);

	public function queryByCheckwithdrawaldate($value);

	public function queryByCheckwithdrawalnote($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByCheckwithdrawalnumber($value);


	public function deleteByBankaccountid($value);

	public function deleteBySupplierid($value);

	public function deleteByAccountbeforevalue($value);

	public function deleteByCheckwithdrawaluser($value);

	public function deleteByCheckwithdrawalamount($value);

	public function deleteByCheckwithdrawaldate($value);

	public function deleteByCheckwithdrawalnote($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByCheckwithdrawalnumber($value);


}
?>